@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress

/**
 * The X12 one-way agreement.
 * @property protocolSettings The X12 protocol settings.
 * @property receiverBusinessIdentity The receiver business identity
 * @property senderBusinessIdentity The sender business identity
 */
public data class X12OneWayAgreementResponse(
    public val protocolSettings: X12ProtocolSettingsResponse,
    public val receiverBusinessIdentity: BusinessIdentityResponse,
    public val senderBusinessIdentity: BusinessIdentityResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.X12OneWayAgreementResponse): X12OneWayAgreementResponse = X12OneWayAgreementResponse(
            protocolSettings = javaType.protocolSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.X12ProtocolSettingsResponse.Companion.toKotlin(args0)
            }),
            receiverBusinessIdentity = javaType.receiverBusinessIdentity().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.BusinessIdentityResponse.Companion.toKotlin(args0)
            }),
            senderBusinessIdentity = javaType.senderBusinessIdentity().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.BusinessIdentityResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
