@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The X12 agreement protocol settings.
 * @property acknowledgementSettings The X12 acknowledgment settings.
 * @property envelopeOverrides The X12 envelope override settings.
 * @property envelopeSettings The X12 envelope settings.
 * @property framingSettings The X12 framing settings.
 * @property messageFilter The X12 message filter.
 * @property messageFilterList The X12 message filter list.
 * @property processingSettings The X12 processing settings.
 * @property schemaReferences The X12 schema references.
 * @property securitySettings The X12 security settings.
 * @property validationOverrides The X12 validation override settings.
 * @property validationSettings The X12 validation settings.
 * @property x12DelimiterOverrides The X12 delimiter override settings.
 */
public data class X12ProtocolSettingsResponse(
    public val acknowledgementSettings: X12AcknowledgementSettingsResponse,
    public val envelopeOverrides: List<X12EnvelopeOverrideResponse>? = null,
    public val envelopeSettings: X12EnvelopeSettingsResponse,
    public val framingSettings: X12FramingSettingsResponse,
    public val messageFilter: X12MessageFilterResponse,
    public val messageFilterList: List<X12MessageIdentifierResponse>? = null,
    public val processingSettings: X12ProcessingSettingsResponse,
    public val schemaReferences: List<X12SchemaReferenceResponse>,
    public val securitySettings: X12SecuritySettingsResponse,
    public val validationOverrides: List<X12ValidationOverrideResponse>? = null,
    public val validationSettings: X12ValidationSettingsResponse,
    public val x12DelimiterOverrides: List<X12DelimiterOverridesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.X12ProtocolSettingsResponse): X12ProtocolSettingsResponse = X12ProtocolSettingsResponse(
            acknowledgementSettings = javaType.acknowledgementSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.X12AcknowledgementSettingsResponse.Companion.toKotlin(args0)
            }),
            envelopeOverrides = javaType.envelopeOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.X12EnvelopeOverrideResponse.Companion.toKotlin(args0)
                })
            }),
            envelopeSettings = javaType.envelopeSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.X12EnvelopeSettingsResponse.Companion.toKotlin(args0)
            }),
            framingSettings = javaType.framingSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.X12FramingSettingsResponse.Companion.toKotlin(args0)
            }),
            messageFilter = javaType.messageFilter().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.X12MessageFilterResponse.Companion.toKotlin(args0)
            }),
            messageFilterList = javaType.messageFilterList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.X12MessageIdentifierResponse.Companion.toKotlin(args0)
                })
            }),
            processingSettings = javaType.processingSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.X12ProcessingSettingsResponse.Companion.toKotlin(args0)
            }),
            schemaReferences = javaType.schemaReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.X12SchemaReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            securitySettings = javaType.securitySettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.X12SecuritySettingsResponse.Companion.toKotlin(args0)
            }),
            validationOverrides = javaType.validationOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.X12ValidationOverrideResponse.Companion.toKotlin(args0)
                })
            }),
            validationSettings = javaType.validationSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.X12ValidationSettingsResponse.Companion.toKotlin(args0)
            }),
            x12DelimiterOverrides = javaType.x12DelimiterOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.X12DelimiterOverridesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
