@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The X12 schema reference.
 * @property messageId The message id.
 * @property schemaName The schema name.
 * @property schemaVersion The schema version.
 * @property senderApplicationId The sender application id.
 */
public data class X12SchemaReferenceResponse(
    public val messageId: String,
    public val schemaName: String,
    public val schemaVersion: String,
    public val senderApplicationId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.X12SchemaReferenceResponse): X12SchemaReferenceResponse = X12SchemaReferenceResponse(
            messageId = javaType.messageId(),
            schemaName = javaType.schemaName(),
            schemaVersion = javaType.schemaVersion(),
            senderApplicationId = javaType.senderApplicationId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
