@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The X12 validation override settings.
 * @property allowLeadingAndTrailingSpacesAndZeroes The value indicating whether to allow leading and trailing spaces and zeroes.
 * @property messageId The message id on which the validation settings has to be applied.
 * @property trailingSeparatorPolicy The trailing separator policy.
 * @property trimLeadingAndTrailingSpacesAndZeroes The value indicating whether to trim leading and trailing spaces and zeroes.
 * @property validateCharacterSet The value indicating whether to validate character Set.
 * @property validateEDITypes The value indicating whether to validate EDI types.
 * @property validateXSDTypes The value indicating whether to validate XSD types.
 */
public data class X12ValidationOverrideResponse(
    public val allowLeadingAndTrailingSpacesAndZeroes: Boolean,
    public val messageId: String,
    public val trailingSeparatorPolicy: String,
    public val trimLeadingAndTrailingSpacesAndZeroes: Boolean,
    public val validateCharacterSet: Boolean,
    public val validateEDITypes: Boolean,
    public val validateXSDTypes: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.X12ValidationOverrideResponse): X12ValidationOverrideResponse = X12ValidationOverrideResponse(
            allowLeadingAndTrailingSpacesAndZeroes = javaType.allowLeadingAndTrailingSpacesAndZeroes(),
            messageId = javaType.messageId(),
            trailingSeparatorPolicy = javaType.trailingSeparatorPolicy(),
            trimLeadingAndTrailingSpacesAndZeroes = javaType.trimLeadingAndTrailingSpacesAndZeroes(),
            validateCharacterSet = javaType.validateCharacterSet(),
            validateEDITypes = javaType.validateEDITypes(),
            validateXSDTypes = javaType.validateXSDTypes(),
        )
    }
}
