@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.FilteringTagArgs.builder
import com.pulumi.azurenative.logz.kotlin.enums.TagAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The definition of a filtering tag. Filtering tags are used for capturing resources and include/exclude them from being monitored.
 * @property action Valid actions for a filtering tag. Exclusion takes priority over inclusion.
 * @property name The name (also known as the key) of the tag.
 * @property value The value of the tag.
 */
public data class FilteringTagArgs(
    public val action: Output<Either<String, TagAction>>? = null,
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.FilteringTagArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.FilteringTagArgs =
        com.pulumi.azurenative.logz.inputs.FilteringTagArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FilteringTagArgs].
 */
@PulumiTagMarker
public class FilteringTagArgsBuilder internal constructor() {
    private var action: Output<Either<String, TagAction>>? = null

    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Valid actions for a filtering tag. Exclusion takes priority over inclusion.
     */
    @JvmName("lgpyecolrfrmkyad")
    public suspend fun action(`value`: Output<Either<String, TagAction>>) {
        this.action = value
    }

    /**
     * @param value The name (also known as the key) of the tag.
     */
    @JvmName("emasxtfrdhunhkld")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the tag.
     */
    @JvmName("mdmnfvibofswcaik")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Valid actions for a filtering tag. Exclusion takes priority over inclusion.
     */
    @JvmName("bsldqdpjlvgbkfey")
    public suspend fun action(`value`: Either<String, TagAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Valid actions for a filtering tag. Exclusion takes priority over inclusion.
     */
    @JvmName("mjlrsythyrncanmx")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TagAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Valid actions for a filtering tag. Exclusion takes priority over inclusion.
     */
    @JvmName("ynmevprspnvvkluw")
    public fun action(`value`: TagAction) {
        val toBeMapped = Either.ofRight<String, TagAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The name (also known as the key) of the tag.
     */
    @JvmName("onrpygiplsvitmwd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the tag.
     */
    @JvmName("tscodgxhiaqjnmyd")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): FilteringTagArgs = FilteringTagArgs(
        action = action,
        name = name,
        `value` = `value`,
    )
}
