@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.IdentityPropertiesArgs.builder
import com.pulumi.azurenative.logz.kotlin.enums.ManagedIdentityTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type
 */
public data class IdentityPropertiesArgs(
    public val type: Output<Either<String, ManagedIdentityTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.IdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.IdentityPropertiesArgs =
        com.pulumi.azurenative.logz.inputs.IdentityPropertiesArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityPropertiesArgs].
 */
@PulumiTagMarker
public class IdentityPropertiesArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedIdentityTypes>>? = null

    /**
     * @param value
     */
    @JvmName("wduydtquujxnxqid")
    public suspend fun type(`value`: Output<Either<String, ManagedIdentityTypes>>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("dwkwukdfigdivpoh")
    public suspend fun type(`value`: Either<String, ManagedIdentityTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("qgqldtsmjkkxjige")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedIdentityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("eulyxkxwogopxhic")
    public fun type(`value`: ManagedIdentityTypes) {
        val toBeMapped = Either.ofRight<String, ManagedIdentityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityPropertiesArgs = IdentityPropertiesArgs(
        type = type,
    )
}
