@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.LogzOrganizationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property companyName Name of the Logz organization.
 * @property enterpriseAppId The Id of the Enterprise App used for Single sign on.
 * @property singleSignOnUrl The login URL specific to this Logz Organization.
 */
public data class LogzOrganizationPropertiesArgs(
    public val companyName: Output<String>? = null,
    public val enterpriseAppId: Output<String>? = null,
    public val singleSignOnUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.LogzOrganizationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.LogzOrganizationPropertiesArgs =
        com.pulumi.azurenative.logz.inputs.LogzOrganizationPropertiesArgs.builder()
            .companyName(companyName?.applyValue({ args0 -> args0 }))
            .enterpriseAppId(enterpriseAppId?.applyValue({ args0 -> args0 }))
            .singleSignOnUrl(singleSignOnUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogzOrganizationPropertiesArgs].
 */
@PulumiTagMarker
public class LogzOrganizationPropertiesArgsBuilder internal constructor() {
    private var companyName: Output<String>? = null

    private var enterpriseAppId: Output<String>? = null

    private var singleSignOnUrl: Output<String>? = null

    /**
     * @param value Name of the Logz organization.
     */
    @JvmName("gvlogtcrwuacqsds")
    public suspend fun companyName(`value`: Output<String>) {
        this.companyName = value
    }

    /**
     * @param value The Id of the Enterprise App used for Single sign on.
     */
    @JvmName("pmxjwghjbhfpgydl")
    public suspend fun enterpriseAppId(`value`: Output<String>) {
        this.enterpriseAppId = value
    }

    /**
     * @param value The login URL specific to this Logz Organization.
     */
    @JvmName("yltxyuuvxyyrjbbf")
    public suspend fun singleSignOnUrl(`value`: Output<String>) {
        this.singleSignOnUrl = value
    }

    /**
     * @param value Name of the Logz organization.
     */
    @JvmName("vcgqcfuwrnftecqu")
    public suspend fun companyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.companyName = mapped
    }

    /**
     * @param value The Id of the Enterprise App used for Single sign on.
     */
    @JvmName("pndiqiwiamyyfqbr")
    public suspend fun enterpriseAppId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enterpriseAppId = mapped
    }

    /**
     * @param value The login URL specific to this Logz Organization.
     */
    @JvmName("ecedrbobukhlonmh")
    public suspend fun singleSignOnUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleSignOnUrl = mapped
    }

    internal fun build(): LogzOrganizationPropertiesArgs = LogzOrganizationPropertiesArgs(
        companyName = companyName,
        enterpriseAppId = enterpriseAppId,
        singleSignOnUrl = singleSignOnUrl,
    )
}
