@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Set of rules for sending metrics for the Monitor resource.
 * @property filteringTags List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
 * @property subscriptionId Subscription Id for which filtering tags are applicable
 */
public data class MetricRulesResponse(
    public val filteringTags: List<FilteringTagResponse>? = null,
    public val subscriptionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.MetricRulesResponse): MetricRulesResponse = MetricRulesResponse(
            filteringTags = javaType.filteringTags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logz.kotlin.outputs.FilteringTagResponse.Companion.toKotlin(args0)
                })
            }),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
