@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties specific to the monitor resource.
 * @property liftrResourceCategory
 * @property liftrResourcePreference The priority of the resource.
 * @property logzOrganizationProperties
 * @property marketplaceSubscriptionStatus Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
 * @property monitoringStatus Flag specifying if the resource monitoring is enabled or disabled.
 * @property planData
 * @property provisioningState Flag specifying if the resource provisioning state as tracked by ARM.
 * @property userInfo
 */
public data class MonitorPropertiesResponse(
    public val liftrResourceCategory: String,
    public val liftrResourcePreference: Int,
    public val logzOrganizationProperties: LogzOrganizationPropertiesResponse? = null,
    public val marketplaceSubscriptionStatus: String? = null,
    public val monitoringStatus: String? = null,
    public val planData: PlanDataResponse? = null,
    public val provisioningState: String,
    public val userInfo: UserInfoResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.MonitorPropertiesResponse): MonitorPropertiesResponse = MonitorPropertiesResponse(
            liftrResourceCategory = javaType.liftrResourceCategory(),
            liftrResourcePreference = javaType.liftrResourcePreference(),
            logzOrganizationProperties = javaType.logzOrganizationProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logz.kotlin.outputs.LogzOrganizationPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            marketplaceSubscriptionStatus = javaType.marketplaceSubscriptionStatus().map({ args0 ->
                args0
            }).orElse(null),
            monitoringStatus = javaType.monitoringStatus().map({ args0 -> args0 }).orElse(null),
            planData = javaType.planData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logz.kotlin.outputs.PlanDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            userInfo = javaType.userInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logz.kotlin.outputs.UserInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
