@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The properties of a resource currently being monitored by the Logz monitor resource.
 * @property id The ARM id of the resource.
 * @property reasonForLogsStatus Reason for why the resource is sending logs (or why it is not sending).
 * @property reasonForMetricsStatus Reason for why the resource is sending metrics (or why it is not sending).
 * @property sendingLogs Flag indicating if resource is sending logs to Logz.
 * @property sendingMetrics Flag indicating if resource is sending metrics to Logz.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 */
public data class MonitoredResourceResponse(
    public val id: String? = null,
    public val reasonForLogsStatus: String? = null,
    public val reasonForMetricsStatus: String? = null,
    public val sendingLogs: Boolean? = null,
    public val sendingMetrics: Boolean? = null,
    public val systemData: SystemDataResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.MonitoredResourceResponse): MonitoredResourceResponse = MonitoredResourceResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            reasonForLogsStatus = javaType.reasonForLogsStatus().map({ args0 -> args0 }).orElse(null),
            reasonForMetricsStatus = javaType.reasonForMetricsStatus().map({ args0 -> args0 }).orElse(null),
            sendingLogs = javaType.sendingLogs().map({ args0 -> args0 }).orElse(null),
            sendingMetrics = javaType.sendingMetrics().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.logz.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
