@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property emailAddress Email of the user used by Logz for contacting them if needed
 * @property firstName First Name of the user
 * @property lastName Last Name of the user
 * @property phoneNumber Phone number of the user used by Logz for contacting them if needed
 */
public data class UserInfoResponse(
    public val emailAddress: String? = null,
    public val firstName: String? = null,
    public val lastName: String? = null,
    public val phoneNumber: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.UserInfoResponse): UserInfoResponse = UserInfoResponse(
            emailAddress = javaType.emailAddress().map({ args0 -> args0 }).orElse(null),
            firstName = javaType.firstName().map({ args0 -> args0 }).orElse(null),
            lastName = javaType.lastName().map({ args0 -> args0 }).orElse(null),
            phoneNumber = javaType.phoneNumber().map({ args0 -> args0 }).orElse(null),
        )
    }
}
