@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.m365securityandcompliance.kotlin

import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.ServicesPropertiesResponse
import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.ServicesResourceResponseIdentity
import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.ServicesPropertiesResponse.Companion.toKotlin as servicesPropertiesResponseToKotlin
import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.ServicesResourceResponseIdentity.Companion.toKotlin as servicesResourceResponseIdentityToKotlin
import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateLinkServicesForM365ComplianceCenter].
 */
@PulumiTagMarker
public class PrivateLinkServicesForM365ComplianceCenterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateLinkServicesForM365ComplianceCenterArgs =
        PrivateLinkServicesForM365ComplianceCenterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateLinkServicesForM365ComplianceCenterArgsBuilder.() -> Unit) {
        val builder = PrivateLinkServicesForM365ComplianceCenterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateLinkServicesForM365ComplianceCenter {
        val builtJavaResource =
            com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForM365ComplianceCenter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateLinkServicesForM365ComplianceCenter(builtJavaResource)
    }
}

/**
 * The description of the service.
 * Azure REST API version: 2021-03-25-preview. Prior API version in Azure Native 1.x: 2021-03-25-preview.
 * ## Example Usage
 * ### Create or Update a service with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkServicesForM365ComplianceCenter = new AzureNative.M365SecurityAndCompliance.PrivateLinkServicesForM365ComplianceCenter("privateLinkServicesForM365ComplianceCenter", new()
 *     {
 *         Identity = new AzureNative.M365SecurityAndCompliance.Inputs.ServicesResourceIdentityArgs
 *         {
 *             Type = AzureNative.M365SecurityAndCompliance.ManagedServiceIdentityType.SystemAssigned,
 *         },
 *         Kind = AzureNative.M365SecurityAndCompliance.Kind.Fhir_R4,
 *         Location = "westus2",
 *         Properties = new AzureNative.M365SecurityAndCompliance.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.M365SecurityAndCompliance.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *                 new AzureNative.M365SecurityAndCompliance.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "5b307da8-43d4-492b-8b66-b0294ade872f",
 *                 },
 *             },
 *             AuthenticationConfiguration = new AzureNative.M365SecurityAndCompliance.Inputs.ServiceAuthenticationConfigurationInfoArgs
 *             {
 *                 Audience = "https://azurehealthcareapis.com",
 *                 Authority = "https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc",
 *                 SmartProxyEnabled = true,
 *             },
 *             CorsConfiguration = new AzureNative.M365SecurityAndCompliance.Inputs.ServiceCorsConfigurationInfoArgs
 *             {
 *                 AllowCredentials = false,
 *                 Headers = new[]
 *                 {
 *                     "*",
 *                 },
 *                 MaxAge = 1440,
 *                 Methods = new[]
 *                 {
 *                     "DELETE",
 *                     "GET",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT",
 *                 },
 *                 Origins = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             CosmosDbConfiguration = new AzureNative.M365SecurityAndCompliance.Inputs.ServiceCosmosDbConfigurationInfoArgs
 *             {
 *                 KeyVaultKeyUri = "https://my-vault.vault.azure.net/keys/my-key",
 *                 OfferThroughput = 1000,
 *             },
 *             ExportConfiguration = new AzureNative.M365SecurityAndCompliance.Inputs.ServiceExportConfigurationInfoArgs
 *             {
 *                 StorageAccountName = "existingStorageAccount",
 *             },
 *             PrivateEndpointConnections = new() { },
 *             PublicNetworkAccess = AzureNative.M365SecurityAndCompliance.PublicNetworkAccess.Disabled,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/m365securityandcompliance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := m365securityandcompliance.NewPrivateLinkServicesForM365ComplianceCenter(ctx, "privateLinkServicesForM365ComplianceCenter", &m365securityandcompliance.PrivateLinkServicesForM365ComplianceCenterArgs{
 * 			Identity: &m365securityandcompliance.ServicesResourceIdentityArgs{
 * 				Type: pulumi.String(m365securityandcompliance.ManagedServiceIdentityTypeSystemAssigned),
 * 			},
 * 			Kind:     m365securityandcompliance.Kind_Fhir_R4,
 * 			Location: pulumi.String("westus2"),
 * 			Properties: &m365securityandcompliance.ServicesPropertiesArgs{
 * 				AccessPolicies: m365securityandcompliance.ServiceAccessPolicyEntryArray{
 * 					&m365securityandcompliance.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 					&m365securityandcompliance.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("5b307da8-43d4-492b-8b66-b0294ade872f"),
 * 					},
 * 				},
 * 				AuthenticationConfiguration: &m365securityandcompliance.ServiceAuthenticationConfigurationInfoArgs{
 * 					Audience:          pulumi.String("https://azurehealthcareapis.com"),
 * 					Authority:         pulumi.String("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
 * 					SmartProxyEnabled: pulumi.Bool(true),
 * 				},
 * 				CorsConfiguration: &m365securityandcompliance.ServiceCorsConfigurationInfoArgs{
 * 					AllowCredentials: pulumi.Bool(false),
 * 					Headers: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					MaxAge: pulumi.Float64(1440),
 * 					Methods: pulumi.StringArray{
 * 						pulumi.String("DELETE"),
 * 						pulumi.String("GET"),
 * 						pulumi.String("OPTIONS"),
 * 						pulumi.String("PATCH"),
 * 						pulumi.String("POST"),
 * 						pulumi.String("PUT"),
 * 					},
 * 					Origins: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 				CosmosDbConfiguration: &m365securityandcompliance.ServiceCosmosDbConfigurationInfoArgs{
 * 					KeyVaultKeyUri:  pulumi.String("https://my-vault.vault.azure.net/keys/my-key"),
 * 					OfferThroughput: pulumi.Float64(1000),
 * 				},
 * 				ExportConfiguration: &m365securityandcompliance.ServiceExportConfigurationInfoArgs{
 * 					StorageAccountName: pulumi.String("existingStorageAccount"),
 * 				},
 * 				PrivateEndpointConnections: m365securityandcompliance.PrivateEndpointConnectionArray{},
 * 				PublicNetworkAccess:        pulumi.String(m365securityandcompliance.PublicNetworkAccessDisabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForM365ComplianceCenter;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForM365ComplianceCenterArgs;
 * import com.pulumi.azurenative.m365securityandcompliance.inputs.ServicesResourceIdentityArgs;
 * import com.pulumi.azurenative.m365securityandcompliance.inputs.ServicesPropertiesArgs;
 * import com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceAuthenticationConfigurationInfoArgs;
 * import com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceCorsConfigurationInfoArgs;
 * import com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceCosmosDbConfigurationInfoArgs;
 * import com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceExportConfigurationInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkServicesForM365ComplianceCenter = new PrivateLinkServicesForM365ComplianceCenter("privateLinkServicesForM365ComplianceCenter", PrivateLinkServicesForM365ComplianceCenterArgs.builder()
 *             .identity(ServicesResourceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("fhir-R4")
 *             .location("westus2")
 *             .properties(ServicesPropertiesArgs.builder()
 *                 .accessPolicies(
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("c487e7d1-3210-41a3-8ccc-e9372b78da47")
 *                         .build(),
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("5b307da8-43d4-492b-8b66-b0294ade872f")
 *                         .build())
 *                 .authenticationConfiguration(ServiceAuthenticationConfigurationInfoArgs.builder()
 *                     .audience("https://azurehealthcareapis.com")
 *                     .authority("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc")
 *                     .smartProxyEnabled(true)
 *                     .build())
 *                 .corsConfiguration(ServiceCorsConfigurationInfoArgs.builder()
 *                     .allowCredentials(false)
 *                     .headers("*")
 *                     .maxAge(1440)
 *                     .methods(
 *                         "DELETE",
 *                         "GET",
 *                         "OPTIONS",
 *                         "PATCH",
 *                         "POST",
 *                         "PUT")
 *                     .origins("*")
 *                     .build())
 *                 .cosmosDbConfiguration(ServiceCosmosDbConfigurationInfoArgs.builder()
 *                     .keyVaultKeyUri("https://my-vault.vault.azure.net/keys/my-key")
 *                     .offerThroughput(1000)
 *                     .build())
 *                 .exportConfiguration(ServiceExportConfigurationInfoArgs.builder()
 *                     .storageAccountName("existingStorageAccount")
 *                     .build())
 *                 .privateEndpointConnections()
 *                 .publicNetworkAccess("Disabled")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("service1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a service with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkServicesForM365ComplianceCenter = new AzureNative.M365SecurityAndCompliance.PrivateLinkServicesForM365ComplianceCenter("privateLinkServicesForM365ComplianceCenter", new()
 *     {
 *         Kind = AzureNative.M365SecurityAndCompliance.Kind.Fhir_R4,
 *         Location = "westus2",
 *         Properties = new AzureNative.M365SecurityAndCompliance.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.M365SecurityAndCompliance.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service2",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/m365securityandcompliance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := m365securityandcompliance.NewPrivateLinkServicesForM365ComplianceCenter(ctx, "privateLinkServicesForM365ComplianceCenter", &m365securityandcompliance.PrivateLinkServicesForM365ComplianceCenterArgs{
 * 			Kind:     m365securityandcompliance.Kind_Fhir_R4,
 * 			Location: pulumi.String("westus2"),
 * 			Properties: &m365securityandcompliance.ServicesPropertiesArgs{
 * 				AccessPolicies: m365securityandcompliance.ServiceAccessPolicyEntryArray{
 * 					&m365securityandcompliance.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service2"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForM365ComplianceCenter;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForM365ComplianceCenterArgs;
 * import com.pulumi.azurenative.m365securityandcompliance.inputs.ServicesPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkServicesForM365ComplianceCenter = new PrivateLinkServicesForM365ComplianceCenter("privateLinkServicesForM365ComplianceCenter", PrivateLinkServicesForM365ComplianceCenterArgs.builder()
 *             .kind("fhir-R4")
 *             .location("westus2")
 *             .properties(ServicesPropertiesArgs.builder()
 *                 .accessPolicies(ServiceAccessPolicyEntryArgs.builder()
 *                     .objectId("c487e7d1-3210-41a3-8ccc-e9372b78da47")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("service2")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:m365securityandcompliance:PrivateLinkServicesForM365ComplianceCenter service2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365ComplianceCenter/{resourceName}
 * ```
 */
public class PrivateLinkServicesForM365ComplianceCenter internal constructor(
    override val javaResource: com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForM365ComplianceCenter,
) : KotlinCustomResource(javaResource, PrivateLinkServicesForM365ComplianceCenterMapper) {
    /**
     * An etag associated with the resource, used for optimistic concurrency when editing it.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Setting indicating whether the service has a managed identity associated with it.
     */
    public val identity: Output<ServicesResourceResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    servicesResourceResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The kind of the service.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The common properties of a service.
     */
    public val properties: Output<ServicesPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                servicesPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Required property for system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateLinkServicesForM365ComplianceCenterMapper :
    ResourceMapper<PrivateLinkServicesForM365ComplianceCenter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForM365ComplianceCenter::class == javaResource::class

    override fun map(javaResource: Resource): PrivateLinkServicesForM365ComplianceCenter =
        PrivateLinkServicesForM365ComplianceCenter(
            javaResource as
                com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForM365ComplianceCenter,
        )
}

/**
 * @see [PrivateLinkServicesForM365ComplianceCenter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateLinkServicesForM365ComplianceCenter].
 */
public suspend fun privateLinkServicesForM365ComplianceCenter(
    name: String,
    block: suspend PrivateLinkServicesForM365ComplianceCenterResourceBuilder.() -> Unit,
): PrivateLinkServicesForM365ComplianceCenter {
    val builder = PrivateLinkServicesForM365ComplianceCenterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateLinkServicesForM365ComplianceCenter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateLinkServicesForM365ComplianceCenter(name: String): PrivateLinkServicesForM365ComplianceCenter {
    val builder = PrivateLinkServicesForM365ComplianceCenterResourceBuilder()
    builder.name(name)
    return builder.build()
}
