@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a service instance.
 * @property accessPolicies The access policies of the service instance.
 * @property authenticationConfiguration The authentication configuration for the service instance.
 * @property corsConfiguration The settings for the CORS configuration of the service instance.
 * @property cosmosDbConfiguration The settings for the Cosmos DB database backing the service.
 * @property exportConfiguration The settings for the export operation of the service instance.
 * @property privateEndpointConnections The list of private endpoint connections that are set up for this resource.
 * @property provisioningState The provisioning state.
 * @property publicNetworkAccess Control permission for data plane traffic coming from public networks while private endpoint is enabled.
 */
public data class ServicesPropertiesResponse(
    public val accessPolicies: List<ServiceAccessPolicyEntryResponse>? = null,
    public val authenticationConfiguration: ServiceAuthenticationConfigurationInfoResponse? = null,
    public val corsConfiguration: ServiceCorsConfigurationInfoResponse? = null,
    public val cosmosDbConfiguration: ServiceCosmosDbConfigurationInfoResponse? = null,
    public val exportConfiguration: ServiceExportConfigurationInfoResponse? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.m365securityandcompliance.outputs.ServicesPropertiesResponse): ServicesPropertiesResponse = ServicesPropertiesResponse(
            accessPolicies = javaType.accessPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.ServiceAccessPolicyEntryResponse.Companion.toKotlin(args0)
                })
            }),
            authenticationConfiguration = javaType.authenticationConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.ServiceAuthenticationConfigurationInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            corsConfiguration = javaType.corsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.ServiceCorsConfigurationInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            cosmosDbConfiguration = javaType.cosmosDbConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.ServiceCosmosDbConfigurationInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            exportConfiguration = javaType.exportConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.ServiceExportConfigurationInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
        )
    }
}
