@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin

import com.pulumi.azurenative.machinelearning.CommitmentPlanArgs.builder
import com.pulumi.azurenative.machinelearning.kotlin.inputs.ResourceSkuArgs
import com.pulumi.azurenative.machinelearning.kotlin.inputs.ResourceSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure ML commitment plan resource.
 * Azure REST API version: 2016-05-01-preview. Prior API version in Azure Native 1.x: 2016-05-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearning:CommitmentPlan myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}
 * ```
 * @property commitmentPlanName The Azure ML commitment plan name.
 * @property location Resource location.
 * @property resourceGroupName The resource group name.
 * @property sku The commitment plan SKU.
 * @property tags User-defined tags for the resource.
 */
public data class CommitmentPlanArgs(
    public val commitmentPlanName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ResourceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.CommitmentPlanArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.CommitmentPlanArgs =
        com.pulumi.azurenative.machinelearning.CommitmentPlanArgs.builder()
            .commitmentPlanName(commitmentPlanName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CommitmentPlanArgs].
 */
@PulumiTagMarker
public class CommitmentPlanArgsBuilder internal constructor() {
    private var commitmentPlanName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ResourceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Azure ML commitment plan name.
     */
    @JvmName("yhfntmwwkpjuyvde")
    public suspend fun commitmentPlanName(`value`: Output<String>) {
        this.commitmentPlanName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xhsrshyngfsymcrw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("yidatvjvbttitpem")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The commitment plan SKU.
     */
    @JvmName("mimuoangpbjytcau")
    public suspend fun sku(`value`: Output<ResourceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value User-defined tags for the resource.
     */
    @JvmName("ndeomrsbvjhebjnk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Azure ML commitment plan name.
     */
    @JvmName("fdmpwjdmrdrnrkvx")
    public suspend fun commitmentPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitmentPlanName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ywxyalufjssoopag")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("hycucyebhyjgxtqq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The commitment plan SKU.
     */
    @JvmName("ccmidmjtsixidyis")
    public suspend fun sku(`value`: ResourceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The commitment plan SKU.
     */
    @JvmName("bwrqvhxwlwewonjs")
    public suspend fun sku(argument: suspend ResourceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value User-defined tags for the resource.
     */
    @JvmName("rnpecojhcjycxuwh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values User-defined tags for the resource.
     */
    @JvmName("uhykxbihobgdnkye")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CommitmentPlanArgs = CommitmentPlanArgs(
        commitmentPlanName = commitmentPlanName,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
