@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.BlobLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the access location for a blob.
 * @property credentials Access credentials for the blob, if applicable (e.g. blob specified by storage account connection string + blob URI)
 * @property uri The URI from which the blob is accessible from. For example, aml://abc for system assets or https://xyz for user assets or payload.
 */
public data class BlobLocationArgs(
    public val credentials: Output<String>? = null,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.BlobLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.BlobLocationArgs =
        com.pulumi.azurenative.machinelearning.inputs.BlobLocationArgs.builder()
            .credentials(credentials?.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobLocationArgs].
 */
@PulumiTagMarker
public class BlobLocationArgsBuilder internal constructor() {
    private var credentials: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value Access credentials for the blob, if applicable (e.g. blob specified by storage account connection string + blob URI)
     */
    @JvmName("lxypierobfpwmagh")
    public suspend fun credentials(`value`: Output<String>) {
        this.credentials = value
    }

    /**
     * @param value The URI from which the blob is accessible from. For example, aml://abc for system assets or https://xyz for user assets or payload.
     */
    @JvmName("ctwbhypiexresurt")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Access credentials for the blob, if applicable (e.g. blob specified by storage account connection string + blob URI)
     */
    @JvmName("smfkbbgahhuivofb")
    public suspend fun credentials(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value The URI from which the blob is accessible from. For example, aml://abc for system assets or https://xyz for user assets or payload.
     */
    @JvmName("cqnxcdnacboypsjh")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): BlobLocationArgs = BlobLocationArgs(
        credentials = credentials,
        uri = uri ?: throw PulumiNullFieldException("uri"),
    )
}
