@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.CommitmentPlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about the machine learning commitment plan associated with the web service.
 * @property id Specifies the Azure Resource Manager ID of the commitment plan associated with the web service.
 */
public data class CommitmentPlanArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.CommitmentPlanArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.CommitmentPlanArgs =
        com.pulumi.azurenative.machinelearning.inputs.CommitmentPlanArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommitmentPlanArgs].
 */
@PulumiTagMarker
public class CommitmentPlanArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Specifies the Azure Resource Manager ID of the commitment plan associated with the web service.
     */
    @JvmName("gcvtnnyxodjuikwp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Specifies the Azure Resource Manager ID of the commitment plan associated with the web service.
     */
    @JvmName("jajfubxrfemlprpp")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): CommitmentPlanArgs = CommitmentPlanArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
