@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.GraphNodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies a node in the web service graph. The node can either be an input, output or asset node, so only one of the corresponding id properties is populated at any given time.
 * @property assetId The id of the asset represented by this node.
 * @property inputId The id of the input element represented by this node.
 * @property outputId The id of the output element represented by this node.
 * @property parameters If applicable, parameters of the node. Global graph parameters map into these, with values set at runtime.
 */
public data class GraphNodeArgs(
    public val assetId: Output<String>? = null,
    public val inputId: Output<String>? = null,
    public val outputId: Output<String>? = null,
    public val parameters: Output<Map<String, WebServiceParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.GraphNodeArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.GraphNodeArgs =
        com.pulumi.azurenative.machinelearning.inputs.GraphNodeArgs.builder()
            .assetId(assetId?.applyValue({ args0 -> args0 }))
            .inputId(inputId?.applyValue({ args0 -> args0 }))
            .outputId(outputId?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GraphNodeArgs].
 */
@PulumiTagMarker
public class GraphNodeArgsBuilder internal constructor() {
    private var assetId: Output<String>? = null

    private var inputId: Output<String>? = null

    private var outputId: Output<String>? = null

    private var parameters: Output<Map<String, WebServiceParameterArgs>>? = null

    /**
     * @param value The id of the asset represented by this node.
     */
    @JvmName("buwkffwumdvpucjr")
    public suspend fun assetId(`value`: Output<String>) {
        this.assetId = value
    }

    /**
     * @param value The id of the input element represented by this node.
     */
    @JvmName("ipyriyrhmotnrpjr")
    public suspend fun inputId(`value`: Output<String>) {
        this.inputId = value
    }

    /**
     * @param value The id of the output element represented by this node.
     */
    @JvmName("foysrqgwsiprkbfb")
    public suspend fun outputId(`value`: Output<String>) {
        this.outputId = value
    }

    /**
     * @param value If applicable, parameters of the node. Global graph parameters map into these, with values set at runtime.
     */
    @JvmName("sulyotsjkijwtlhl")
    public suspend fun parameters(`value`: Output<Map<String, WebServiceParameterArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The id of the asset represented by this node.
     */
    @JvmName("svmyucecfwkuplgn")
    public suspend fun assetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetId = mapped
    }

    /**
     * @param value The id of the input element represented by this node.
     */
    @JvmName("bwmrivklqoqliniu")
    public suspend fun inputId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputId = mapped
    }

    /**
     * @param value The id of the output element represented by this node.
     */
    @JvmName("vjupgjqcjglyptal")
    public suspend fun outputId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputId = mapped
    }

    /**
     * @param value If applicable, parameters of the node. Global graph parameters map into these, with values set at runtime.
     */
    @JvmName("xfjnrmkgilryrstk")
    public suspend fun parameters(`value`: Map<String, WebServiceParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument If applicable, parameters of the node. Global graph parameters map into these, with values set at runtime.
     */
    @JvmName("dgfgifulnfxxkkaj")
    public suspend fun parameters(vararg argument: Pair<String, suspend WebServiceParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                WebServiceParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values If applicable, parameters of the node. Global graph parameters map into these, with values set at runtime.
     */
    @JvmName("flpjmvmmndqkhhkf")
    public fun parameters(vararg values: Pair<String, WebServiceParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): GraphNodeArgs = GraphNodeArgs(
        assetId = assetId,
        inputId = inputId,
        outputId = outputId,
        parameters = parameters,
    )
}
