@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.GraphParameterLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Association link for a graph global parameter to a node in the graph.
 * @property nodeId The graph node's identifier
 * @property parameterKey The identifier of the node parameter that the global parameter maps to.
 */
public data class GraphParameterLinkArgs(
    public val nodeId: Output<String>,
    public val parameterKey: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.GraphParameterLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.GraphParameterLinkArgs =
        com.pulumi.azurenative.machinelearning.inputs.GraphParameterLinkArgs.builder()
            .nodeId(nodeId.applyValue({ args0 -> args0 }))
            .parameterKey(parameterKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphParameterLinkArgs].
 */
@PulumiTagMarker
public class GraphParameterLinkArgsBuilder internal constructor() {
    private var nodeId: Output<String>? = null

    private var parameterKey: Output<String>? = null

    /**
     * @param value The graph node's identifier
     */
    @JvmName("jykmkpjdjvusisie")
    public suspend fun nodeId(`value`: Output<String>) {
        this.nodeId = value
    }

    /**
     * @param value The identifier of the node parameter that the global parameter maps to.
     */
    @JvmName("wfgekoktrvclhdhi")
    public suspend fun parameterKey(`value`: Output<String>) {
        this.parameterKey = value
    }

    /**
     * @param value The graph node's identifier
     */
    @JvmName("tqxfevclijchwqni")
    public suspend fun nodeId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeId = mapped
    }

    /**
     * @param value The identifier of the node parameter that the global parameter maps to.
     */
    @JvmName("ikrlwokhtsrgleew")
    public suspend fun parameterKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterKey = mapped
    }

    internal fun build(): GraphParameterLinkArgs = GraphParameterLinkArgs(
        nodeId = nodeId ?: throw PulumiNullFieldException("nodeId"),
        parameterKey = parameterKey ?: throw PulumiNullFieldException("parameterKey"),
    )
}
