@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.RealtimeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Holds the available configuration options for an Azure ML web service endpoint.
 * @property maxConcurrentCalls Specifies the maximum concurrent calls that can be made to the web service. Minimum value: 4, Maximum value: 200.
 */
public data class RealtimeConfigurationArgs(
    public val maxConcurrentCalls: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.RealtimeConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.RealtimeConfigurationArgs =
        com.pulumi.azurenative.machinelearning.inputs.RealtimeConfigurationArgs.builder()
            .maxConcurrentCalls(maxConcurrentCalls?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RealtimeConfigurationArgs].
 */
@PulumiTagMarker
public class RealtimeConfigurationArgsBuilder internal constructor() {
    private var maxConcurrentCalls: Output<Int>? = null

    /**
     * @param value Specifies the maximum concurrent calls that can be made to the web service. Minimum value: 4, Maximum value: 200.
     */
    @JvmName("xfvmrcyuupvcrpkp")
    public suspend fun maxConcurrentCalls(`value`: Output<Int>) {
        this.maxConcurrentCalls = value
    }

    /**
     * @param value Specifies the maximum concurrent calls that can be made to the web service. Minimum value: 4, Maximum value: 200.
     */
    @JvmName("tcravhlunbqpkacm")
    public suspend fun maxConcurrentCalls(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentCalls = mapped
    }

    internal fun build(): RealtimeConfigurationArgs = RealtimeConfigurationArgs(
        maxConcurrentCalls = maxConcurrentCalls,
    )
}
