@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sku of the resource
 * @property name Name of the sku
 * @property tier Tier of the sku like Basic or Enterprise
 */
public data class SkuArgs(
    public val name: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.SkuArgs =
        com.pulumi.azurenative.machinelearning.inputs.SkuArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value Name of the sku
     */
    @JvmName("kqvvphvkgbgirkrx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Tier of the sku like Basic or Enterprise
     */
    @JvmName("tubfrhtkaijrhryw")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Name of the sku
     */
    @JvmName("ghsufkmlklrsmggu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tier of the sku like Basic or Enterprise
     */
    @JvmName("polqehraryycvgri")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name,
        tier = tier,
    )
}
