@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.WebServiceKeysArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Access keys for the web service calls.
 * @property primary The primary access key.
 * @property secondary The secondary access key.
 */
public data class WebServiceKeysArgs(
    public val primary: Output<String>? = null,
    public val secondary: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.WebServiceKeysArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.WebServiceKeysArgs =
        com.pulumi.azurenative.machinelearning.inputs.WebServiceKeysArgs.builder()
            .primary(primary?.applyValue({ args0 -> args0 }))
            .secondary(secondary?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebServiceKeysArgs].
 */
@PulumiTagMarker
public class WebServiceKeysArgsBuilder internal constructor() {
    private var primary: Output<String>? = null

    private var secondary: Output<String>? = null

    /**
     * @param value The primary access key.
     */
    @JvmName("fufhaagwndkujbfu")
    public suspend fun primary(`value`: Output<String>) {
        this.primary = value
    }

    /**
     * @param value The secondary access key.
     */
    @JvmName("equovfgxopshrpeb")
    public suspend fun secondary(`value`: Output<String>) {
        this.secondary = value
    }

    /**
     * @param value The primary access key.
     */
    @JvmName("lhbbkmwawnprpxni")
    public suspend fun primary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value The secondary access key.
     */
    @JvmName("cqfoiwhsqbsjsqft")
    public suspend fun secondary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondary = mapped
    }

    internal fun build(): WebServiceKeysArgs = WebServiceKeysArgs(
        primary = primary,
        secondary = secondary,
    )
}
