@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.WebServiceParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Web Service Parameter object for node and global parameter
 * @property certificateThumbprint If the parameter value in 'value' field is encrypted, the thumbprint of the certificate should be put here.
 * @property value The parameter value
 */
public data class WebServiceParameterArgs(
    public val certificateThumbprint: Output<String>? = null,
    public val `value`: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.WebServiceParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.WebServiceParameterArgs =
        com.pulumi.azurenative.machinelearning.inputs.WebServiceParameterArgs.builder()
            .certificateThumbprint(certificateThumbprint?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebServiceParameterArgs].
 */
@PulumiTagMarker
public class WebServiceParameterArgsBuilder internal constructor() {
    private var certificateThumbprint: Output<String>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value If the parameter value in 'value' field is encrypted, the thumbprint of the certificate should be put here.
     */
    @JvmName("eajrjrdiopgdjlmv")
    public suspend fun certificateThumbprint(`value`: Output<String>) {
        this.certificateThumbprint = value
    }

    /**
     * @param value The parameter value
     */
    @JvmName("kwncbnbipmjxrmld")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value If the parameter value in 'value' field is encrypted, the thumbprint of the certificate should be put here.
     */
    @JvmName("gnsvrisowvkjstdj")
    public suspend fun certificateThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateThumbprint = mapped
    }

    /**
     * @param value The parameter value
     */
    @JvmName("ejkqvranooikwkyd")
    public suspend fun `value`(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): WebServiceParameterArgs = WebServiceParameterArgs(
        certificateThumbprint = certificateThumbprint,
        `value` = `value`,
    )
}
