@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the access location for a blob.
 * @property credentials Access credentials for the blob, if applicable (e.g. blob specified by storage account connection string + blob URI)
 * @property uri The URI from which the blob is accessible from. For example, aml://abc for system assets or https://xyz for user assets or payload.
 */
public data class BlobLocationResponse(
    public val credentials: String? = null,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.BlobLocationResponse): BlobLocationResponse = BlobLocationResponse(
            credentials = javaType.credentials().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri(),
        )
    }
}
