@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An object that represents a machine learning workspace.
 * @property creationTime The creation time for this workspace resource.
 * @property id The resource ID.
 * @property keyVaultIdentifierId The key vault identifier used for encrypted workspaces.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property name The name of the resource.
 * @property ownerEmail The email id of the owner for this workspace.
 * @property sku The sku of the workspace.
 * @property studioEndpoint The regional endpoint for the machine learning studio service which hosts this workspace.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property userStorageAccountId The fully qualified arm id of the storage account associated with this workspace.
 * @property workspaceId The immutable id associated with this workspace.
 * @property workspaceState The current state of workspace resource.
 * @property workspaceType The type of this workspace.
 */
public data class GetWorkspaceResult(
    public val creationTime: String,
    public val id: String,
    public val keyVaultIdentifierId: String? = null,
    public val location: String,
    public val name: String,
    public val ownerEmail: String,
    public val sku: SkuResponse? = null,
    public val studioEndpoint: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userStorageAccountId: String,
    public val workspaceId: String,
    public val workspaceState: String,
    public val workspaceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.GetWorkspaceResult): GetWorkspaceResult = GetWorkspaceResult(
            creationTime = javaType.creationTime(),
            id = javaType.id(),
            keyVaultIdentifierId = javaType.keyVaultIdentifierId().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            ownerEmail = javaType.ownerEmail(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            studioEndpoint = javaType.studioEndpoint(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userStorageAccountId = javaType.userStorageAccountId(),
            workspaceId = javaType.workspaceId(),
            workspaceState = javaType.workspaceState(),
            workspaceType = javaType.workspaceType(),
        )
    }
}
