@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines an edge within the web service's graph.
 * @property sourceNodeId The source graph node's identifier.
 * @property sourcePortId The identifier of the source node's port that the edge connects from.
 * @property targetNodeId The destination graph node's identifier.
 * @property targetPortId The identifier of the destination node's port that the edge connects into.
 */
public data class GraphEdgeResponse(
    public val sourceNodeId: String? = null,
    public val sourcePortId: String? = null,
    public val targetNodeId: String? = null,
    public val targetPortId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.GraphEdgeResponse): GraphEdgeResponse = GraphEdgeResponse(
            sourceNodeId = javaType.sourceNodeId().map({ args0 -> args0 }).orElse(null),
            sourcePortId = javaType.sourcePortId().map({ args0 -> args0 }).orElse(null),
            targetNodeId = javaType.targetNodeId().map({ args0 -> args0 }).orElse(null),
            targetPortId = javaType.targetPortId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
