@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Specifies a node in the web service graph. The node can either be an input, output or asset node, so only one of the corresponding id properties is populated at any given time.
 * @property assetId The id of the asset represented by this node.
 * @property inputId The id of the input element represented by this node.
 * @property outputId The id of the output element represented by this node.
 * @property parameters If applicable, parameters of the node. Global graph parameters map into these, with values set at runtime.
 */
public data class GraphNodeResponse(
    public val assetId: String? = null,
    public val inputId: String? = null,
    public val outputId: String? = null,
    public val parameters: Map<String, WebServiceParameterResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.GraphNodeResponse): GraphNodeResponse = GraphNodeResponse(
            assetId = javaType.assetId().map({ args0 -> args0 }).orElse(null),
            inputId = javaType.inputId().map({ args0 -> args0 }).orElse(null),
            outputId = javaType.outputId().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearning.kotlin.outputs.WebServiceParameterResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
