@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines the graph of modules making up the machine learning solution.
 * @property edges The list of edges making up the graph.
 * @property graphParameters The collection of global parameters for the graph, given as a global parameter name to GraphParameter map. Each parameter here has a 1:1 match with the global parameters values map declared at the WebServiceProperties level.
 * @property nodes The set of nodes making up the graph, provided as a nodeId to GraphNode map
 */
public data class GraphPackageResponse(
    public val edges: List<GraphEdgeResponse>? = null,
    public val graphParameters: Map<String, GraphParameterResponse>? = null,
    public val nodes: Map<String, GraphNodeResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.GraphPackageResponse): GraphPackageResponse = GraphPackageResponse(
            edges = javaType.edges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.GraphEdgeResponse.Companion.toKotlin(args0)
                })
            }),
            graphParameters = javaType.graphParameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearning.kotlin.outputs.GraphParameterResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            nodes = javaType.nodes().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearning.kotlin.outputs.GraphNodeResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
