@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a global parameter in the graph.
 * @property description Description of this graph parameter.
 * @property links Association links for this parameter to nodes in the graph.
 * @property type Graph parameter's type.
 */
public data class GraphParameterResponse(
    public val description: String? = null,
    public val links: List<GraphParameterLinkResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.GraphParameterResponse): GraphParameterResponse = GraphParameterResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            links = javaType.links().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.GraphParameterLinkResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
