@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Parameter definition for a module asset.
 * @property modeValuesInfo Definitions for nested interface parameters if this is a complex module parameter.
 * @property name Parameter name.
 * @property parameterType Parameter type.
 */
public data class ModuleAssetParameterResponse(
    public val modeValuesInfo: Map<String, ModeValueInfoResponse>? = null,
    public val name: String? = null,
    public val parameterType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.ModuleAssetParameterResponse): ModuleAssetParameterResponse = ModuleAssetParameterResponse(
            modeValuesInfo = javaType.modeValuesInfo().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearning.kotlin.outputs.ModeValueInfoResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            parameterType = javaType.parameterType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
