@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Holds the available configuration options for an Azure ML web service endpoint.
 * @property maxConcurrentCalls Specifies the maximum concurrent calls that can be made to the web service. Minimum value: 4, Maximum value: 200.
 */
public data class RealtimeConfigurationResponse(
    public val maxConcurrentCalls: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.RealtimeConfigurationResponse): RealtimeConfigurationResponse = RealtimeConfigurationResponse(
            maxConcurrentCalls = javaType.maxConcurrentCalls().map({ args0 -> args0 }).orElse(null),
        )
    }
}
