@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The SKU of a resource.
 * @property capacity The scale-out capacity of the resource. 1 is 1x, 2 is 2x, etc. This impacts the quantities and cost of any commitment plan resource.
 * @property name The SKU name. Along with tier, uniquely identifies the SKU.
 * @property tier The SKU tier. Along with name, uniquely identifies the SKU.
 */
public data class ResourceSkuResponse(
    public val capacity: Int? = null,
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.ResourceSkuResponse): ResourceSkuResponse = ResourceSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
