@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Sku of the resource
 * @property name Name of the sku
 * @property tier Tier of the sku like Basic or Enterprise
 */
public data class SkuResponse(
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.SkuResponse): SkuResponse = SkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
