@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Access keys for the web service calls.
 * @property primary The primary access key.
 * @property secondary The secondary access key.
 */
public data class WebServiceKeysResponse(
    public val primary: String? = null,
    public val secondary: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.WebServiceKeysResponse): WebServiceKeysResponse = WebServiceKeysResponse(
            primary = javaType.primary().map({ args0 -> args0 }).orElse(null),
            secondary = javaType.secondary().map({ args0 -> args0 }).orElse(null),
        )
    }
}
