@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.CapacityReservationGroupArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-08-01-preview.
 * Other available API versions: 2024-01-01-preview, 2024-04-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:CapacityReservationGroup string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/capacityReserverationGroups/{groupId}
 * ```
 * @property capacityReservationGroupProperties [Required] Additional attributes of the entity.
 * @property groupId
 * @property identity Managed service identity (system assigned and/or user assigned identities)
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku Sku details required for ARM contract for Autoscaling.
 * @property tags Resource tags.
 */
public data class CapacityReservationGroupArgs(
    public val capacityReservationGroupProperties: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CapacityReservationGroupArgs>? =
        null,
    public val groupId: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.CapacityReservationGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.CapacityReservationGroupArgs = com.pulumi.azurenative.machinelearningservices.CapacityReservationGroupArgs.builder()
        .capacityReservationGroupProperties(
            capacityReservationGroupProperties?.applyValue({ args0 ->
                args0.let({ args0 -> args0.toJava() })
            }),
        )
        .groupId(groupId?.applyValue({ args0 -> args0 }))
        .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .kind(kind?.applyValue({ args0 -> args0 }))
        .location(location?.applyValue({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
        .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [CapacityReservationGroupArgs].
 */
@PulumiTagMarker
public class CapacityReservationGroupArgsBuilder internal constructor() {
    private var capacityReservationGroupProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CapacityReservationGroupArgs>? =
        null

    private var groupId: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("vwxocdrfxjlkpoks")
    public suspend fun capacityReservationGroupProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CapacityReservationGroupArgs>) {
        this.capacityReservationGroupProperties = value
    }

    /**
     * @param value
     */
    @JvmName("ilxdowwwqrawoxyu")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("ydsjgocxbuphqneb")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
     */
    @JvmName("ejdofwtemsmbuysu")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hgvggeddfhoqhnyn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mhskhygmogsuskpv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("sueugmfmrwqofdhc")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("llgdkiuwslgotkwc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("klpwfagdmgljqfcx")
    public suspend fun capacityReservationGroupProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CapacityReservationGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationGroupProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("wpjuvbvppdbdngdr")
    public suspend fun capacityReservationGroupProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CapacityReservationGroupArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CapacityReservationGroupArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.capacityReservationGroupProperties = mapped
    }

    /**
     * @param value
     */
    @JvmName("tdqidfilbswgcjxc")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("uutkvjjggerutyka")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("adrqspikiwywwuoh")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
     */
    @JvmName("mtngyafwuwwlbdsx")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hmpkahxiywdtekbk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("drbfnrdrwhewjwto")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("nwiaeeodftfwlnxq")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("qlgovmqwxasuhuwh")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iosrputhkphgbyry")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gvutvuhnaqfhmdjs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CapacityReservationGroupArgs = CapacityReservationGroupArgs(
        capacityReservationGroupProperties = capacityReservationGroupProperties,
        groupId = groupId,
        identity = identity,
        kind = kind,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
