@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.ConnectionDeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2024-04-01-preview.
 * ## Example Usage
 * ### Create Azure OpenAI Connection Deployment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionDeployment = new AzureNative.MachineLearningServices.ConnectionDeployment("connectionDeployment", new()
 *     {
 *         ConnectionName = "testConnection",
 *         DeploymentName = "text-davinci-003",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.OpenAIEndpointDeploymentResourcePropertiesArgs
 *         {
 *             Model = new AzureNative.MachineLearningServices.Inputs.EndpointDeploymentModelArgs
 *             {
 *                 Format = "OpenAI",
 *                 Name = "text-davinci-003",
 *                 Version = "1",
 *             },
 *             Type = "Azure.OpenAI",
 *             VersionUpgradeOption = AzureNative.MachineLearningServices.DeploymentModelVersionUpgradeOption.OnceNewDefaultVersionAvailable,
 *         },
 *         ResourceGroupName = "resourceGroup-1",
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewConnectionDeployment(ctx, "connectionDeployment", &machinelearningservices.ConnectionDeploymentArgs{
 * 			ConnectionName: pulumi.String("testConnection"),
 * 			DeploymentName: pulumi.String("text-davinci-003"),
 * 			Properties: machinelearningservices.OpenAIEndpointDeploymentResourceProperties{
 * 				Model: machinelearningservices.EndpointDeploymentModel{
 * 					Format:  "OpenAI",
 * 					Name:    "text-davinci-003",
 * 					Version: "1",
 * 				},
 * 				Type:                 "Azure.OpenAI",
 * 				VersionUpgradeOption: machinelearningservices.DeploymentModelVersionUpgradeOptionOnceNewDefaultVersionAvailable,
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup-1"),
 * 			WorkspaceName:     pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionDeployment;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionDeployment = new ConnectionDeployment("connectionDeployment", ConnectionDeploymentArgs.builder()
 *             .connectionName("testConnection")
 *             .deploymentName("text-davinci-003")
 *             .properties(ContentSafetyEndpointDeploymentResourcePropertiesArgs.builder()
 *                 .model(EndpointDeploymentModelArgs.builder()
 *                     .format("OpenAI")
 *                     .name("text-davinci-003")
 *                     .version("1")
 *                     .build())
 *                 .type("Azure.OpenAI")
 *                 .versionUpgradeOption("OnceNewDefaultVersionAvailable")
 *                 .build())
 *             .resourceGroupName("resourceGroup-1")
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ConnectionDeployment text-davinci-003 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/connections/{connectionName}/deployments/{deploymentName}
 * ```
 * @property connectionName Friendly name of the workspace connection
 * @property deploymentName Name of the deployment resource
 * @property properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Azure Machine Learning Workspace Name
 */
public data class ConnectionDeploymentArgs(
    public val connectionName: Output<String>? = null,
    public val deploymentName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.ConnectionDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.ConnectionDeploymentArgs =
        com.pulumi.azurenative.machinelearningservices.ConnectionDeploymentArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionDeploymentArgs].
 */
@PulumiTagMarker
public class ConnectionDeploymentArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var deploymentName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Friendly name of the workspace connection
     */
    @JvmName("vsiixjliigtirgyr")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Name of the deployment resource
     */
    @JvmName("fskdbxxyjryvgqnq")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value
     */
    @JvmName("oidquxwlxgekkgwm")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tklkneygyvukmung")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("odhhrkffoojbqcaj")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Friendly name of the workspace connection
     */
    @JvmName("qsrxjcgtpupuvhwq")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Name of the deployment resource
     */
    @JvmName("yaepipvevbnnmjti")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    /**
     * @param value
     */
    @JvmName("woriphwjeisyskbv")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mcowhdwuiibswoij")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("rifveguhplvsbwtm")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ConnectionDeploymentArgs = ConnectionDeploymentArgs(
        connectionName = connectionName,
        deploymentName = deploymentName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
