@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RaiBlocklistItemPropertiesResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RaiBlocklistItemPropertiesResponse.Companion.toKotlin as raiBlocklistItemPropertiesResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConnectionRaiBlocklist].
 */
@PulumiTagMarker
public class ConnectionRaiBlocklistResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionRaiBlocklistArgs = ConnectionRaiBlocklistArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionRaiBlocklistArgsBuilder.() -> Unit) {
        val builder = ConnectionRaiBlocklistArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConnectionRaiBlocklist {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklist(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectionRaiBlocklist(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2024-04-01-preview.
 * ## Example Usage
 * ### Create RaiBlocklist Item
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionRaiBlocklist = new AzureNative.MachineLearningServices.ConnectionRaiBlocklist("connectionRaiBlocklist", new()
 *     {
 *         ConnectionName = "testConnection",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.RaiBlocklistItemPropertiesArgs
 *         {
 *             IsRegex = false,
 *             Pattern = "Pattern To Block",
 *         },
 *         RaiBlocklistItemName = "raiBlocklistItemName",
 *         RaiBlocklistName = "raiBlocklistName",
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "aml-workspace-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewConnectionRaiBlocklist(ctx, "connectionRaiBlocklist", &machinelearningservices.ConnectionRaiBlocklistArgs{
 * 			ConnectionName: pulumi.String("testConnection"),
 * 			Properties: &machinelearningservices.RaiBlocklistItemPropertiesArgs{
 * 				IsRegex: pulumi.Bool(false),
 * 				Pattern: pulumi.String("Pattern To Block"),
 * 			},
 * 			RaiBlocklistItemName: pulumi.String("raiBlocklistItemName"),
 * 			RaiBlocklistName:     pulumi.String("raiBlocklistName"),
 * 			ResourceGroupName:    pulumi.String("test-rg"),
 * 			WorkspaceName:        pulumi.String("aml-workspace-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklist;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.RaiBlocklistItemPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionRaiBlocklist = new ConnectionRaiBlocklist("connectionRaiBlocklist", ConnectionRaiBlocklistArgs.builder()
 *             .connectionName("testConnection")
 *             .properties(RaiBlocklistItemPropertiesArgs.builder()
 *                 .isRegex(false)
 *                 .pattern("Pattern To Block")
 *                 .build())
 *             .raiBlocklistItemName("raiBlocklistItemName")
 *             .raiBlocklistName("raiBlocklistName")
 *             .resourceGroupName("test-rg")
 *             .workspaceName("aml-workspace-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ConnectionRaiBlocklist raiBlocklistItemName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/connections/{connectionName}/raiBlocklists/{raiBlocklistName}/raiBlocklistItems/{raiBlocklistItemName}
 * ```
 */
public class ConnectionRaiBlocklist internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklist,
) : KotlinCustomResource(javaResource, ConnectionRaiBlocklistMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * RAI Custom Blocklist Item properties.
     */
    public val properties: Output<RaiBlocklistItemPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                raiBlocklistItemPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectionRaiBlocklistMapper : ResourceMapper<ConnectionRaiBlocklist> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklist::class == javaResource::class

    override fun map(javaResource: Resource): ConnectionRaiBlocklist =
        ConnectionRaiBlocklist(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklist,
        )
}

/**
 * @see [ConnectionRaiBlocklist].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectionRaiBlocklist].
 */
public suspend fun connectionRaiBlocklist(
    name: String,
    block: suspend ConnectionRaiBlocklistResourceBuilder.() -> Unit,
): ConnectionRaiBlocklist {
    val builder = ConnectionRaiBlocklistResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectionRaiBlocklist].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectionRaiBlocklist(name: String): ConnectionRaiBlocklist {
    val builder = ConnectionRaiBlocklistResourceBuilder()
    builder.name(name)
    return builder.build()
}
