@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RaiBlocklistItemPropertiesArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RaiBlocklistItemPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2024-04-01-preview.
 * ## Example Usage
 * ### Create RaiBlocklist Item
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionRaiBlocklist = new AzureNative.MachineLearningServices.ConnectionRaiBlocklist("connectionRaiBlocklist", new()
 *     {
 *         ConnectionName = "testConnection",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.RaiBlocklistItemPropertiesArgs
 *         {
 *             IsRegex = false,
 *             Pattern = "Pattern To Block",
 *         },
 *         RaiBlocklistItemName = "raiBlocklistItemName",
 *         RaiBlocklistName = "raiBlocklistName",
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "aml-workspace-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewConnectionRaiBlocklist(ctx, "connectionRaiBlocklist", &machinelearningservices.ConnectionRaiBlocklistArgs{
 * 			ConnectionName: pulumi.String("testConnection"),
 * 			Properties: &machinelearningservices.RaiBlocklistItemPropertiesArgs{
 * 				IsRegex: pulumi.Bool(false),
 * 				Pattern: pulumi.String("Pattern To Block"),
 * 			},
 * 			RaiBlocklistItemName: pulumi.String("raiBlocklistItemName"),
 * 			RaiBlocklistName:     pulumi.String("raiBlocklistName"),
 * 			ResourceGroupName:    pulumi.String("test-rg"),
 * 			WorkspaceName:        pulumi.String("aml-workspace-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklist;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.RaiBlocklistItemPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionRaiBlocklist = new ConnectionRaiBlocklist("connectionRaiBlocklist", ConnectionRaiBlocklistArgs.builder()
 *             .connectionName("testConnection")
 *             .properties(RaiBlocklistItemPropertiesArgs.builder()
 *                 .isRegex(false)
 *                 .pattern("Pattern To Block")
 *                 .build())
 *             .raiBlocklistItemName("raiBlocklistItemName")
 *             .raiBlocklistName("raiBlocklistName")
 *             .resourceGroupName("test-rg")
 *             .workspaceName("aml-workspace-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ConnectionRaiBlocklist raiBlocklistItemName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/connections/{connectionName}/raiBlocklists/{raiBlocklistName}/raiBlocklistItems/{raiBlocklistItemName}
 * ```
 * @property connectionName Friendly name of the workspace connection
 * @property properties RAI Custom Blocklist Item properties.
 * @property raiBlocklistItemName Name of the RaiBlocklist Item
 * @property raiBlocklistName The name of the RaiBlocklist.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Azure Machine Learning Workspace Name
 */
public data class ConnectionRaiBlocklistArgs(
    public val connectionName: Output<String>? = null,
    public val properties: Output<RaiBlocklistItemPropertiesArgs>? = null,
    public val raiBlocklistItemName: Output<String>? = null,
    public val raiBlocklistName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistArgs =
        com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .raiBlocklistItemName(raiBlocklistItemName?.applyValue({ args0 -> args0 }))
            .raiBlocklistName(raiBlocklistName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionRaiBlocklistArgs].
 */
@PulumiTagMarker
public class ConnectionRaiBlocklistArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var properties: Output<RaiBlocklistItemPropertiesArgs>? = null

    private var raiBlocklistItemName: Output<String>? = null

    private var raiBlocklistName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Friendly name of the workspace connection
     */
    @JvmName("stjnenhcdpesebgn")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value RAI Custom Blocklist Item properties.
     */
    @JvmName("jigvynxrnoqudacb")
    public suspend fun properties(`value`: Output<RaiBlocklistItemPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the RaiBlocklist Item
     */
    @JvmName("koowtjbswckiexxs")
    public suspend fun raiBlocklistItemName(`value`: Output<String>) {
        this.raiBlocklistItemName = value
    }

    /**
     * @param value The name of the RaiBlocklist.
     */
    @JvmName("bxpaxukwlhnvxcan")
    public suspend fun raiBlocklistName(`value`: Output<String>) {
        this.raiBlocklistName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cojphanetdrxiqkn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("kyfadgwrkqjxlaoa")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Friendly name of the workspace connection
     */
    @JvmName("vytepqbviscjnysp")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value RAI Custom Blocklist Item properties.
     */
    @JvmName("gcekncematkgekqg")
    public suspend fun properties(`value`: RaiBlocklistItemPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument RAI Custom Blocklist Item properties.
     */
    @JvmName("xrgfyijtckuqokwh")
    public suspend fun properties(argument: suspend RaiBlocklistItemPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RaiBlocklistItemPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the RaiBlocklist Item
     */
    @JvmName("aglbxsfgimhyvelg")
    public suspend fun raiBlocklistItemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raiBlocklistItemName = mapped
    }

    /**
     * @param value The name of the RaiBlocklist.
     */
    @JvmName("afbucviarvhgeeil")
    public suspend fun raiBlocklistName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raiBlocklistName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sienbxcppevptyke")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("srdhxedkrgobrnef")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ConnectionRaiBlocklistArgs = ConnectionRaiBlocklistArgs(
        connectionName = connectionName,
        properties = properties,
        raiBlocklistItemName = raiBlocklistItemName,
        raiBlocklistName = raiBlocklistName,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
