@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RaiBlocklistPropertiesResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RaiBlocklistPropertiesResponse.Companion.toKotlin as raiBlocklistPropertiesResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConnectionRaiBlocklistItem].
 */
@PulumiTagMarker
public class ConnectionRaiBlocklistItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionRaiBlocklistItemArgs = ConnectionRaiBlocklistItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionRaiBlocklistItemArgsBuilder.() -> Unit) {
        val builder = ConnectionRaiBlocklistItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConnectionRaiBlocklistItem {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItem(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectionRaiBlocklistItem(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2024-04-01-preview.
 * ## Example Usage
 * ### Create Rai Blocklist
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionRaiBlocklistItem = new AzureNative.MachineLearningServices.ConnectionRaiBlocklistItem("connectionRaiBlocklistItem", new()
 *     {
 *         ConnectionName = "testConnection",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.RaiBlocklistPropertiesArgs
 *         {
 *             Description = "Basic blocklist description",
 *         },
 *         RaiBlocklistName = "raiBlocklistName",
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "aml-workspace-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewConnectionRaiBlocklistItem(ctx, "connectionRaiBlocklistItem", &machinelearningservices.ConnectionRaiBlocklistItemArgs{
 * 			ConnectionName: pulumi.String("testConnection"),
 * 			Properties: &machinelearningservices.RaiBlocklistPropertiesArgs{
 * 				Description: pulumi.String("Basic blocklist description"),
 * 			},
 * 			RaiBlocklistName:  pulumi.String("raiBlocklistName"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			WorkspaceName:     pulumi.String("aml-workspace-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItem;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItemArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.RaiBlocklistPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionRaiBlocklistItem = new ConnectionRaiBlocklistItem("connectionRaiBlocklistItem", ConnectionRaiBlocklistItemArgs.builder()
 *             .connectionName("testConnection")
 *             .properties(RaiBlocklistPropertiesArgs.builder()
 *                 .description("Basic blocklist description")
 *                 .build())
 *             .raiBlocklistName("raiBlocklistName")
 *             .resourceGroupName("test-rg")
 *             .workspaceName("aml-workspace-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ConnectionRaiBlocklistItem raiBlocklistName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/connections/{connectionName}/raiBlocklists/{raiBlocklistName}
 * ```
 */
public class ConnectionRaiBlocklistItem internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItem,
) : KotlinCustomResource(javaResource, ConnectionRaiBlocklistItemMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * RAI Custom Blocklist properties.
     */
    public val properties: Output<RaiBlocklistPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                raiBlocklistPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectionRaiBlocklistItemMapper : ResourceMapper<ConnectionRaiBlocklistItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItem::class == javaResource::class

    override fun map(javaResource: Resource): ConnectionRaiBlocklistItem =
        ConnectionRaiBlocklistItem(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItem,
        )
}

/**
 * @see [ConnectionRaiBlocklistItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectionRaiBlocklistItem].
 */
public suspend fun connectionRaiBlocklistItem(
    name: String,
    block: suspend ConnectionRaiBlocklistItemResourceBuilder.() -> Unit,
): ConnectionRaiBlocklistItem {
    val builder = ConnectionRaiBlocklistItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectionRaiBlocklistItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectionRaiBlocklistItem(name: String): ConnectionRaiBlocklistItem {
    val builder = ConnectionRaiBlocklistItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
