@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItemArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RaiBlocklistPropertiesArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RaiBlocklistPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2024-04-01-preview.
 * ## Example Usage
 * ### Create Rai Blocklist
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionRaiBlocklistItem = new AzureNative.MachineLearningServices.ConnectionRaiBlocklistItem("connectionRaiBlocklistItem", new()
 *     {
 *         ConnectionName = "testConnection",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.RaiBlocklistPropertiesArgs
 *         {
 *             Description = "Basic blocklist description",
 *         },
 *         RaiBlocklistName = "raiBlocklistName",
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "aml-workspace-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewConnectionRaiBlocklistItem(ctx, "connectionRaiBlocklistItem", &machinelearningservices.ConnectionRaiBlocklistItemArgs{
 * 			ConnectionName: pulumi.String("testConnection"),
 * 			Properties: &machinelearningservices.RaiBlocklistPropertiesArgs{
 * 				Description: pulumi.String("Basic blocklist description"),
 * 			},
 * 			RaiBlocklistName:  pulumi.String("raiBlocklistName"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			WorkspaceName:     pulumi.String("aml-workspace-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItem;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItemArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.RaiBlocklistPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionRaiBlocklistItem = new ConnectionRaiBlocklistItem("connectionRaiBlocklistItem", ConnectionRaiBlocklistItemArgs.builder()
 *             .connectionName("testConnection")
 *             .properties(RaiBlocklistPropertiesArgs.builder()
 *                 .description("Basic blocklist description")
 *                 .build())
 *             .raiBlocklistName("raiBlocklistName")
 *             .resourceGroupName("test-rg")
 *             .workspaceName("aml-workspace-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ConnectionRaiBlocklistItem raiBlocklistName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/connections/{connectionName}/raiBlocklists/{raiBlocklistName}
 * ```
 * @property connectionName Friendly name of the workspace connection
 * @property properties RAI Custom Blocklist properties.
 * @property raiBlocklistName The name of the RaiBlocklist.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Azure Machine Learning Workspace Name
 */
public data class ConnectionRaiBlocklistItemArgs(
    public val connectionName: Output<String>? = null,
    public val properties: Output<RaiBlocklistPropertiesArgs>? = null,
    public val raiBlocklistName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItemArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItemArgs =
        com.pulumi.azurenative.machinelearningservices.ConnectionRaiBlocklistItemArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .raiBlocklistName(raiBlocklistName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionRaiBlocklistItemArgs].
 */
@PulumiTagMarker
public class ConnectionRaiBlocklistItemArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var properties: Output<RaiBlocklistPropertiesArgs>? = null

    private var raiBlocklistName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Friendly name of the workspace connection
     */
    @JvmName("ltxtiknwkvrpqoju")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value RAI Custom Blocklist properties.
     */
    @JvmName("bkdlbtfrawgbesor")
    public suspend fun properties(`value`: Output<RaiBlocklistPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the RaiBlocklist.
     */
    @JvmName("xfeudmfcsbibedas")
    public suspend fun raiBlocklistName(`value`: Output<String>) {
        this.raiBlocklistName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mblbuebstmppxjdv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("mbuaavqybaobwhkq")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Friendly name of the workspace connection
     */
    @JvmName("mgvjttwagsalqyhg")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value RAI Custom Blocklist properties.
     */
    @JvmName("pjipwnvpypbeictj")
    public suspend fun properties(`value`: RaiBlocklistPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument RAI Custom Blocklist properties.
     */
    @JvmName("pkjcuenpfqqgpyhv")
    public suspend fun properties(argument: suspend RaiBlocklistPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RaiBlocklistPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the RaiBlocklist.
     */
    @JvmName("gwgcryoxtxwvqrkk")
    public suspend fun raiBlocklistName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raiBlocklistName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wkmhtlxafvietsjc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("xjclkxgqupplpuws")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ConnectionRaiBlocklistItemArgs = ConnectionRaiBlocklistItemArgs(
        connectionName = connectionName,
        properties = properties,
        raiBlocklistName = raiBlocklistName,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
