@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RaiPolicyPropertiesResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RaiPolicyPropertiesResponse.Companion.toKotlin as raiPolicyPropertiesResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConnectionRaiPolicy].
 */
@PulumiTagMarker
public class ConnectionRaiPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionRaiPolicyArgs = ConnectionRaiPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionRaiPolicyArgsBuilder.() -> Unit) {
        val builder = ConnectionRaiPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConnectionRaiPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.ConnectionRaiPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectionRaiPolicy(builtJavaResource)
    }
}

/**
 * Azure OpenAI Content Filters resource.
 * Azure REST API version: 2024-04-01-preview.
 * ## Example Usage
 * ### Create Rai policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionRaiPolicy = new AzureNative.MachineLearningServices.ConnectionRaiPolicy("connectionRaiPolicy", new()
 *     {
 *         ConnectionName = "testConnection",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.RaiPolicyPropertiesArgs
 *         {
 *             BasePolicyName = "112",
 *             CompletionBlocklists = new[]
 *             {
 *                 new AzureNative.MachineLearningServices.Inputs.RaiBlocklistConfigArgs
 *                 {
 *                     Blocking = false,
 *                     BlocklistName = "blocklistName",
 *                 },
 *             },
 *             ContentFilters = new[]
 *             {
 *                 new AzureNative.MachineLearningServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.MachineLearningServices.AllowedContentLevel.Low,
 *                     Blocking = false,
 *                     Enabled = false,
 *                     Name = "policyName",
 *                     Source = AzureNative.MachineLearningServices.RaiPolicyContentSource.Prompt,
 *                 },
 *             },
 *             Mode = AzureNative.MachineLearningServices.RaiPolicyMode.Blocking,
 *             PromptBlocklists = new[]
 *             {
 *                 new AzureNative.MachineLearningServices.Inputs.RaiBlocklistConfigArgs
 *                 {
 *                     Blocking = false,
 *                     BlocklistName = "blocklistName",
 *                 },
 *             },
 *             Type = AzureNative.MachineLearningServices.RaiPolicyType.SystemManaged,
 *         },
 *         RaiPolicyName = "raiPolicyName",
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "aml-workspace-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewConnectionRaiPolicy(ctx, "connectionRaiPolicy", &machinelearningservices.ConnectionRaiPolicyArgs{
 * 			ConnectionName: pulumi.String("testConnection"),
 * 			Properties: &machinelearningservices.RaiPolicyPropertiesArgs{
 * 				BasePolicyName: pulumi.String("112"),
 * 				CompletionBlocklists: machinelearningservices.RaiBlocklistConfigArray{
 * 					&machinelearningservices.RaiBlocklistConfigArgs{
 * 						Blocking:      pulumi.Bool(false),
 * 						BlocklistName: pulumi.String("blocklistName"),
 * 					},
 * 				},
 * 				ContentFilters: machinelearningservices.RaiPolicyContentFilterArray{
 * 					&machinelearningservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(machinelearningservices.AllowedContentLevelLow),
 * 						Blocking:            pulumi.Bool(false),
 * 						Enabled:             pulumi.Bool(false),
 * 						Name:                pulumi.String("policyName"),
 * 						Source:              pulumi.String(machinelearningservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 				},
 * 				Mode: pulumi.String(machinelearningservices.RaiPolicyModeBlocking),
 * 				PromptBlocklists: machinelearningservices.RaiBlocklistConfigArray{
 * 					&machinelearningservices.RaiBlocklistConfigArgs{
 * 						Blocking:      pulumi.Bool(false),
 * 						BlocklistName: pulumi.String("blocklistName"),
 * 					},
 * 				},
 * 				Type: pulumi.String(machinelearningservices.RaiPolicyTypeSystemManaged),
 * 			},
 * 			RaiPolicyName:     pulumi.String("raiPolicyName"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			WorkspaceName:     pulumi.String("aml-workspace-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionRaiPolicy;
 * import com.pulumi.azurenative.machinelearningservices.ConnectionRaiPolicyArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.RaiPolicyPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionRaiPolicy = new ConnectionRaiPolicy("connectionRaiPolicy", ConnectionRaiPolicyArgs.builder()
 *             .connectionName("testConnection")
 *             .properties(RaiPolicyPropertiesArgs.builder()
 *                 .basePolicyName("112")
 *                 .completionBlocklists(RaiBlocklistConfigArgs.builder()
 *                     .blocking(false)
 *                     .blocklistName("blocklistName")
 *                     .build())
 *                 .contentFilters(RaiPolicyContentFilterArgs.builder()
 *                     .allowedContentLevel("Low")
 *                     .blocking(false)
 *                     .enabled(false)
 *                     .name("policyName")
 *                     .source("Prompt")
 *                     .build())
 *                 .mode("Blocking")
 *                 .promptBlocklists(RaiBlocklistConfigArgs.builder()
 *                     .blocking(false)
 *                     .blocklistName("blocklistName")
 *                     .build())
 *                 .type("SystemManaged")
 *                 .build())
 *             .raiPolicyName("raiPolicyName")
 *             .resourceGroupName("test-rg")
 *             .workspaceName("aml-workspace-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ConnectionRaiPolicy raiPolicyName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/connections/{connectionName}/raiPolicies/{raiPolicyName}
 * ```
 */
public class ConnectionRaiPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.ConnectionRaiPolicy,
) : KotlinCustomResource(javaResource, ConnectionRaiPolicyMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure OpenAI Content Filters properties.
     */
    public val properties: Output<RaiPolicyPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                raiPolicyPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectionRaiPolicyMapper : ResourceMapper<ConnectionRaiPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.ConnectionRaiPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ConnectionRaiPolicy = ConnectionRaiPolicy(
        javaResource
            as com.pulumi.azurenative.machinelearningservices.ConnectionRaiPolicy,
    )
}

/**
 * @see [ConnectionRaiPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectionRaiPolicy].
 */
public suspend fun connectionRaiPolicy(
    name: String,
    block: suspend ConnectionRaiPolicyResourceBuilder.() -> Unit,
): ConnectionRaiPolicy {
    val builder = ConnectionRaiPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectionRaiPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectionRaiPolicy(name: String): ConnectionRaiPolicy {
    val builder = ConnectionRaiPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
