@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DataContainerResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DataContainerResponse.Companion.toKotlin as dataContainerResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DataContainer].
 */
@PulumiTagMarker
public class DataContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataContainerArgs = DataContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataContainerArgsBuilder.() -> Unit) {
        val builder = DataContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataContainer {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.DataContainer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataContainer(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Data Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataContainer = new AzureNative.MachineLearningServices.DataContainer("dataContainer", new()
 *     {
 *         DataContainerProperties = new AzureNative.MachineLearningServices.Inputs.DataContainerArgs
 *         {
 *             DataType = "UriFile",
 *             Description = "string",
 *             Properties =
 *             {
 *                 { "properties1", "value1" },
 *                 { "properties2", "value2" },
 *             },
 *             Tags =
 *             {
 *                 { "tag1", "value1" },
 *                 { "tag2", "value2" },
 *             },
 *         },
 *         Name = "datacontainer123",
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspace123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewDataContainer(ctx, "dataContainer", &machinelearningservices.DataContainerArgs{
 * 			DataContainerProperties: &machinelearningservices.DataContainerTypeArgs{
 * 				DataType:    pulumi.String("UriFile"),
 * 				Description: pulumi.String("string"),
 * 				Properties: pulumi.StringMap{
 * 					"properties1": pulumi.String("value1"),
 * 					"properties2": pulumi.String("value2"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"tag1": pulumi.String("value1"),
 * 					"tag2": pulumi.String("value2"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("datacontainer123"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspace123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.DataContainer;
 * import com.pulumi.azurenative.machinelearningservices.DataContainerArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.DataContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataContainer = new DataContainer("dataContainer", DataContainerArgs.builder()
 *             .dataContainerProperties(DataContainerArgs.builder()
 *                 .dataType("UriFile")
 *                 .description("string")
 *                 .properties(Map.ofEntries(
 *                     Map.entry("properties1", "value1"),
 *                     Map.entry("properties2", "value2")
 *                 ))
 *                 .tags(Map.ofEntries(
 *                     Map.entry("tag1", "value1"),
 *                     Map.entry("tag2", "value2")
 *                 ))
 *                 .build())
 *             .name("datacontainer123")
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspace123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:DataContainer datacontainer123 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/data/{name}
 * ```
 */
public class DataContainer internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.DataContainer,
) : KotlinCustomResource(javaResource, DataContainerMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val dataContainerProperties: Output<DataContainerResponse>
        get() = javaResource.dataContainerProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                dataContainerResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataContainerMapper : ResourceMapper<DataContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.DataContainer::class == javaResource::class

    override fun map(javaResource: Resource): DataContainer = DataContainer(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.DataContainer,
    )
}

/**
 * @see [DataContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataContainer].
 */
public suspend fun dataContainer(
    name: String,
    block: suspend DataContainerResourceBuilder.() -> Unit,
): DataContainer {
    val builder = DataContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataContainer(name: String): DataContainer {
    val builder = DataContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
