@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.DataVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Data Version Base.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataVersion = new AzureNative.MachineLearningServices.DataVersion("dataVersion", new()
 *     {
 *         DataVersionBaseProperties = new AzureNative.MachineLearningServices.Inputs.UriFileDataVersionArgs
 *         {
 *             DataType = "uri_file",
 *             DataUri = "string",
 *             Description = "string",
 *             IsAnonymous = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewDataVersion(ctx, "dataVersion", &machinelearningservices.DataVersionArgs{
 * 			DataVersionBaseProperties: machinelearningservices.UriFileDataVersion{
 * 				DataType:    "uri_file",
 * 				DataUri:     "string",
 * 				Description: "string",
 * 				IsAnonymous: false,
 * 				Properties: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 				Tags: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.DataVersion;
 * import com.pulumi.azurenative.machinelearningservices.DataVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataVersion = new DataVersion("dataVersion", DataVersionArgs.builder()
 *             .dataVersionBaseProperties(MLTableDataArgs.builder()
 *                 .dataType("uri_file")
 *                 .dataUri("string")
 *                 .description("string")
 *                 .isAnonymous(false)
 *                 .properties(Map.of("string", "string"))
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:DataVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/data/{name}/versions/{version}
 * ```
 * @property dataVersionBaseProperties [Required] Additional attributes of the entity.
 * @property name Container name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class DataVersionArgs(
    public val dataVersionBaseProperties: Output<Any>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.DataVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.DataVersionArgs =
        com.pulumi.azurenative.machinelearningservices.DataVersionArgs.builder()
            .dataVersionBaseProperties(dataVersionBaseProperties?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataVersionArgs].
 */
@PulumiTagMarker
public class DataVersionArgsBuilder internal constructor() {
    private var dataVersionBaseProperties: Output<Any>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("ndtdmhcogbeoqidg")
    public suspend fun dataVersionBaseProperties(`value`: Output<Any>) {
        this.dataVersionBaseProperties = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("pqcxdlgviacyxavm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("epofavrthmlqunes")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("jvarrtnosxpqvpxc")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("qldvhhiukupbqlpb")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("sfwmiqrdfgcseybn")
    public suspend fun dataVersionBaseProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataVersionBaseProperties = mapped
    }

    /**
     * @param value Container name.
     */
    @JvmName("amknlwqxkyvmrnno")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("grfivxfyuuwiqkwu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("gmwiovtqodvtdaqb")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("kebediprhgfwvyav")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): DataVersionArgs = DataVersionArgs(
        dataVersionBaseProperties = dataVersionBaseProperties,
        name = name,
        resourceGroupName = resourceGroupName,
        version = version,
        workspaceName = workspaceName,
    )
}
