@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.FeaturesetVersionResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.FeaturesetVersionResponse.Companion.toKotlin as featuresetVersionResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [FeaturesetVersion].
 */
@PulumiTagMarker
public class FeaturesetVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FeaturesetVersionArgs = FeaturesetVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FeaturesetVersionArgsBuilder.() -> Unit) {
        val builder = FeaturesetVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FeaturesetVersion {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.FeaturesetVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FeaturesetVersion(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Featureset Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var featuresetVersion = new AzureNative.MachineLearningServices.FeaturesetVersion("featuresetVersion", new()
 *     {
 *         FeaturesetVersionProperties = new AzureNative.MachineLearningServices.Inputs.FeaturesetVersionArgs
 *         {
 *             Description = "string",
 *             Entities = new[]
 *             {
 *                 "string",
 *             },
 *             IsAnonymous = false,
 *             IsArchived = false,
 *             MaterializationSettings = new AzureNative.MachineLearningServices.Inputs.MaterializationSettingsArgs
 *             {
 *                 Notification = new AzureNative.MachineLearningServices.Inputs.NotificationSettingArgs
 *                 {
 *                     EmailOn = new[]
 *                     {
 *                         AzureNative.MachineLearningServices.EmailNotificationEnableType.JobFailed,
 *                     },
 *                     Emails = new[]
 *                     {
 *                         "string",
 *                     },
 *                 },
 *                 Resource = new AzureNative.MachineLearningServices.Inputs.MaterializationComputeResourceArgs
 *                 {
 *                     InstanceType = "string",
 *                 },
 *                 Schedule = new AzureNative.MachineLearningServices.Inputs.RecurrenceTriggerArgs
 *                 {
 *                     EndTime = "string",
 *                     Frequency = AzureNative.MachineLearningServices.RecurrenceFrequency.Day,
 *                     Interval = 1,
 *                     Schedule = new AzureNative.MachineLearningServices.Inputs.RecurrenceScheduleArgs
 *                     {
 *                         Hours = new[]
 *                         {
 *                             1,
 *                         },
 *                         Minutes = new[]
 *                         {
 *                             1,
 *                         },
 *                         MonthDays = new[]
 *                         {
 *                             1,
 *                         },
 *                         WeekDays = new[]
 *                         {
 *                             AzureNative.MachineLearningServices.WeekDay.Monday,
 *                         },
 *                     },
 *                     StartTime = "string",
 *                     TimeZone = "string",
 *                     TriggerType = "Recurrence",
 *                 },
 *                 SparkConfiguration =
 *                 {
 *                     { "string", "string" },
 *                 },
 *                 StoreType = AzureNative.MachineLearningServices.MaterializationStoreType.Online,
 *             },
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Specification = new AzureNative.MachineLearningServices.Inputs.FeaturesetSpecificationArgs
 *             {
 *                 Path = "string",
 *             },
 *             Stage = "string",
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewFeaturesetVersion(ctx, "featuresetVersion", &machinelearningservices.FeaturesetVersionArgs{
 * FeaturesetVersionProperties: &machinelearningservices.FeaturesetVersionTypeArgs{
 * Description: pulumi.String("string"),
 * Entities: pulumi.StringArray{
 * pulumi.String("string"),
 * },
 * IsAnonymous: pulumi.Bool(false),
 * IsArchived: pulumi.Bool(false),
 * MaterializationSettings: &machinelearningservices.MaterializationSettingsArgs{
 * Notification: &machinelearningservices.NotificationSettingArgs{
 * EmailOn: pulumi.StringArray{
 * pulumi.String(machinelearningservices.EmailNotificationEnableTypeJobFailed),
 * },
 * Emails: pulumi.StringArray{
 * pulumi.String("string"),
 * },
 * },
 * Resource: &machinelearningservices.MaterializationComputeResourceArgs{
 * InstanceType: pulumi.String("string"),
 * },
 * Schedule: interface{}{
 * EndTime: pulumi.String("string"),
 * Frequency: pulumi.String(machinelearningservices.RecurrenceFrequencyDay),
 * Interval: pulumi.Int(1),
 * Schedule: &machinelearningservices.RecurrenceScheduleArgs{
 * Hours: pulumi.IntArray{
 * pulumi.Int(1),
 * },
 * Minutes: pulumi.IntArray{
 * pulumi.Int(1),
 * },
 * MonthDays: pulumi.IntArray{
 * pulumi.Int(1),
 * },
 * WeekDays: pulumi.StringArray{
 * pulumi.String(machinelearningservices.WeekDayMonday),
 * },
 * },
 * StartTime: pulumi.String("string"),
 * TimeZone: pulumi.String("string"),
 * TriggerType: pulumi.String("Recurrence"),
 * },
 * SparkConfiguration: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * StoreType: pulumi.String(machinelearningservices.MaterializationStoreTypeOnline),
 * },
 * Properties: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * Specification: &machinelearningservices.FeaturesetSpecificationArgs{
 * Path: pulumi.String("string"),
 * },
 * Stage: pulumi.String("string"),
 * Tags: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * },
 * Name: pulumi.String("string"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * Version: pulumi.String("string"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.FeaturesetVersion;
 * import com.pulumi.azurenative.machinelearningservices.FeaturesetVersionArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.FeaturesetVersionArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.MaterializationSettingsArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.NotificationSettingArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.MaterializationComputeResourceArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceTriggerArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceScheduleArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.FeaturesetSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var featuresetVersion = new FeaturesetVersion("featuresetVersion", FeaturesetVersionArgs.builder()
 *             .featuresetVersionProperties(FeaturesetVersionArgs.builder()
 *                 .description("string")
 *                 .entities("string")
 *                 .isAnonymous(false)
 *                 .isArchived(false)
 *                 .materializationSettings(MaterializationSettingsArgs.builder()
 *                     .notification(NotificationSettingArgs.builder()
 *                         .emailOn("JobFailed")
 *                         .emails("string")
 *                         .build())
 *                     .resource(MaterializationComputeResourceArgs.builder()
 *                         .instanceType("string")
 *                         .build())
 *                     .schedule(RecurrenceTriggerArgs.builder()
 *                         .endTime("string")
 *                         .frequency("Day")
 *                         .interval(1)
 *                         .schedule(RecurrenceScheduleArgs.builder()
 *                             .hours(1)
 *                             .minutes(1)
 *                             .monthDays(1)
 *                             .weekDays("Monday")
 *                             .build())
 *                         .startTime("string")
 *                         .timeZone("string")
 *                         .triggerType("Recurrence")
 *                         .build())
 *                     .sparkConfiguration(Map.of("string", "string"))
 *                     .storeType("Online")
 *                     .build())
 *                 .properties(Map.of("string", "string"))
 *                 .specification(FeaturesetSpecificationArgs.builder()
 *                     .path("string")
 *                     .build())
 *                 .stage("string")
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:FeaturesetVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/featuresets/{name}/versions/{version}
 * ```
 */
public class FeaturesetVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.FeaturesetVersion,
) : KotlinCustomResource(javaResource, FeaturesetVersionMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val featuresetVersionProperties: Output<FeaturesetVersionResponse>
        get() = javaResource.featuresetVersionProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                featuresetVersionResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FeaturesetVersionMapper : ResourceMapper<FeaturesetVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.FeaturesetVersion::class == javaResource::class

    override fun map(javaResource: Resource): FeaturesetVersion = FeaturesetVersion(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.FeaturesetVersion,
    )
}

/**
 * @see [FeaturesetVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FeaturesetVersion].
 */
public suspend fun featuresetVersion(
    name: String,
    block: suspend FeaturesetVersionResourceBuilder.() -> Unit,
): FeaturesetVersion {
    val builder = FeaturesetVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FeaturesetVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun featuresetVersion(name: String): FeaturesetVersion {
    val builder = FeaturesetVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
