@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.FeaturestoreEntityVersionResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.FeaturestoreEntityVersionResponse.Companion.toKotlin as featurestoreEntityVersionResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [FeaturestoreEntityVersion].
 */
@PulumiTagMarker
public class FeaturestoreEntityVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FeaturestoreEntityVersionArgs = FeaturestoreEntityVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FeaturestoreEntityVersionArgsBuilder.() -> Unit) {
        val builder = FeaturestoreEntityVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FeaturestoreEntityVersion {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FeaturestoreEntityVersion(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Featurestore Entity Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var featurestoreEntityVersion = new AzureNative.MachineLearningServices.FeaturestoreEntityVersion("featurestoreEntityVersion", new()
 *     {
 *         FeaturestoreEntityVersionProperties = new AzureNative.MachineLearningServices.Inputs.FeaturestoreEntityVersionArgs
 *         {
 *             Description = "string",
 *             IndexColumns = new[]
 *             {
 *                 new AzureNative.MachineLearningServices.Inputs.IndexColumnArgs
 *                 {
 *                     ColumnName = "string",
 *                     DataType = AzureNative.MachineLearningServices.FeatureDataType.Datetime,
 *                 },
 *             },
 *             IsAnonymous = false,
 *             IsArchived = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewFeaturestoreEntityVersion(ctx, "featurestoreEntityVersion", &machinelearningservices.FeaturestoreEntityVersionArgs{
 * 			FeaturestoreEntityVersionProperties: &machinelearningservices.FeaturestoreEntityVersionTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				IndexColumns: machinelearningservices.IndexColumnArray{
 * 					&machinelearningservices.IndexColumnArgs{
 * 						ColumnName: pulumi.String("string"),
 * 						DataType:   pulumi.String(machinelearningservices.FeatureDataTypeDatetime),
 * 					},
 * 				},
 * 				IsAnonymous: pulumi.Bool(false),
 * 				IsArchived:  pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersion;
 * import com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersionArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.FeaturestoreEntityVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var featurestoreEntityVersion = new FeaturestoreEntityVersion("featurestoreEntityVersion", FeaturestoreEntityVersionArgs.builder()
 *             .featurestoreEntityVersionProperties(FeaturestoreEntityVersionArgs.builder()
 *                 .description("string")
 *                 .indexColumns(IndexColumnArgs.builder()
 *                     .columnName("string")
 *                     .dataType("Datetime")
 *                     .build())
 *                 .isAnonymous(false)
 *                 .isArchived(false)
 *                 .properties(Map.of("string", "string"))
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:FeaturestoreEntityVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/featurestoreEntities/{name}/versions/{version}
 * ```
 */
public class FeaturestoreEntityVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersion,
) : KotlinCustomResource(javaResource, FeaturestoreEntityVersionMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val featurestoreEntityVersionProperties: Output<FeaturestoreEntityVersionResponse>
        get() = javaResource.featurestoreEntityVersionProperties().applyValue({ args0 ->
            args0.let({ args0 -> featurestoreEntityVersionResponseToKotlin(args0) })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FeaturestoreEntityVersionMapper : ResourceMapper<FeaturestoreEntityVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersion::class == javaResource::class

    override fun map(javaResource: Resource): FeaturestoreEntityVersion =
        FeaturestoreEntityVersion(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersion,
        )
}

/**
 * @see [FeaturestoreEntityVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FeaturestoreEntityVersion].
 */
public suspend fun featurestoreEntityVersion(
    name: String,
    block: suspend FeaturestoreEntityVersionResourceBuilder.() -> Unit,
): FeaturestoreEntityVersion {
    val builder = FeaturestoreEntityVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FeaturestoreEntityVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun featurestoreEntityVersion(name: String): FeaturestoreEntityVersion {
    val builder = FeaturestoreEntityVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
