@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Featurestore Entity Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var featurestoreEntityVersion = new AzureNative.MachineLearningServices.FeaturestoreEntityVersion("featurestoreEntityVersion", new()
 *     {
 *         FeaturestoreEntityVersionProperties = new AzureNative.MachineLearningServices.Inputs.FeaturestoreEntityVersionArgs
 *         {
 *             Description = "string",
 *             IndexColumns = new[]
 *             {
 *                 new AzureNative.MachineLearningServices.Inputs.IndexColumnArgs
 *                 {
 *                     ColumnName = "string",
 *                     DataType = AzureNative.MachineLearningServices.FeatureDataType.Datetime,
 *                 },
 *             },
 *             IsAnonymous = false,
 *             IsArchived = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewFeaturestoreEntityVersion(ctx, "featurestoreEntityVersion", &machinelearningservices.FeaturestoreEntityVersionArgs{
 * 			FeaturestoreEntityVersionProperties: &machinelearningservices.FeaturestoreEntityVersionTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				IndexColumns: machinelearningservices.IndexColumnArray{
 * 					&machinelearningservices.IndexColumnArgs{
 * 						ColumnName: pulumi.String("string"),
 * 						DataType:   pulumi.String(machinelearningservices.FeatureDataTypeDatetime),
 * 					},
 * 				},
 * 				IsAnonymous: pulumi.Bool(false),
 * 				IsArchived:  pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersion;
 * import com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersionArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.FeaturestoreEntityVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var featurestoreEntityVersion = new FeaturestoreEntityVersion("featurestoreEntityVersion", FeaturestoreEntityVersionArgs.builder()
 *             .featurestoreEntityVersionProperties(FeaturestoreEntityVersionArgs.builder()
 *                 .description("string")
 *                 .indexColumns(IndexColumnArgs.builder()
 *                     .columnName("string")
 *                     .dataType("Datetime")
 *                     .build())
 *                 .isAnonymous(false)
 *                 .isArchived(false)
 *                 .properties(Map.of("string", "string"))
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:FeaturestoreEntityVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/featurestoreEntities/{name}/versions/{version}
 * ```
 * @property featurestoreEntityVersionProperties [Required] Additional attributes of the entity.
 * @property name Container name. This is case-sensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier. This is case-sensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class FeaturestoreEntityVersionArgs(
    public val featurestoreEntityVersionProperties: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturestoreEntityVersionArgs>? =
        null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersionArgs =
        com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityVersionArgs.builder()
            .featurestoreEntityVersionProperties(
                featurestoreEntityVersionProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeaturestoreEntityVersionArgs].
 */
@PulumiTagMarker
public class FeaturestoreEntityVersionArgsBuilder internal constructor() {
    private var featurestoreEntityVersionProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturestoreEntityVersionArgs>? =
        null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("aunyitchakmnagih")
    public suspend fun featurestoreEntityVersionProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturestoreEntityVersionArgs>) {
        this.featurestoreEntityVersionProperties = value
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("qbxjouvludrjparh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("phnlpayrtsfoopwo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Version identifier. This is case-sensitive.
     */
    @JvmName("biilfoicojpktpeq")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("qqngctvihsdykbvd")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("xjyvfflfwxkqgxfp")
    public suspend fun featurestoreEntityVersionProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturestoreEntityVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featurestoreEntityVersionProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("qjjbhgqdfaxjnqxv")
    public suspend fun featurestoreEntityVersionProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturestoreEntityVersionArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturestoreEntityVersionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.featurestoreEntityVersionProperties = mapped
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("rydqawkjdphehwyl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lobrdmjhmkbekbdd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier. This is case-sensitive.
     */
    @JvmName("pijutdspxlkgfndo")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("sdnbdqcaimapkaws")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): FeaturestoreEntityVersionArgs = FeaturestoreEntityVersionArgs(
        featurestoreEntityVersionProperties = featurestoreEntityVersionProperties,
        name = name,
        resourceGroupName = resourceGroupName,
        version = version,
        workspaceName = workspaceName,
    )
}
