@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LinkedServicePropsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LinkedServicePropsResponse.Companion.toKotlin as linkedServicePropsResponseToKotlin

/**
 * Builder for [LinkedService].
 */
@PulumiTagMarker
public class LinkedServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkedServiceArgs = LinkedServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkedServiceArgsBuilder.() -> Unit) {
        val builder = LinkedServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LinkedService {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.LinkedService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LinkedService(builtJavaResource)
    }
}

/**
 * Linked service.
 * Azure REST API version: 2020-09-01-preview. Prior API version in Azure Native 1.x: 2020-09-01-preview.
 * ## Example Usage
 * ### CreateLinkedService
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedService = new AzureNative.MachineLearningServices.LinkedService("linkedService", new()
 *     {
 *         Identity = new AzureNative.MachineLearningServices.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.MachineLearningServices.ResourceIdentityType.SystemAssigned,
 *         },
 *         LinkName = "link-1",
 *         Location = "westus",
 *         Name = "link-1",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.LinkedServicePropsArgs
 *         {
 *             LinkedServiceResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/Syn-1",
 *         },
 *         ResourceGroupName = "resourceGroup-1",
 *         WorkspaceName = "workspace-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewLinkedService(ctx, "linkedService", &machinelearningservices.LinkedServiceArgs{
 * 			Identity: &machinelearningservices.IdentityArgs{
 * 				Type: machinelearningservices.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			LinkName: pulumi.String("link-1"),
 * 			Location: pulumi.String("westus"),
 * 			Name:     pulumi.String("link-1"),
 * 			Properties: &machinelearningservices.LinkedServicePropsArgs{
 * 				LinkedServiceResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/Syn-1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup-1"),
 * 			WorkspaceName:     pulumi.String("workspace-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.LinkedService;
 * import com.pulumi.azurenative.machinelearningservices.LinkedServiceArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.IdentityArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.LinkedServicePropsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedService = new LinkedService("linkedService", LinkedServiceArgs.builder()
 *             .identity(IdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .linkName("link-1")
 *             .location("westus")
 *             .name("link-1")
 *             .properties(LinkedServicePropsArgs.builder()
 *                 .linkedServiceResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/Syn-1")
 *                 .build())
 *             .resourceGroupName("resourceGroup-1")
 *             .workspaceName("workspace-1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:LinkedService link-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/linkedServices/{linkName}
 * ```
 */
public class LinkedService internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.LinkedService,
) : KotlinCustomResource(javaResource, LinkedServiceMapper) {
    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * location of the linked service.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Friendly name of the linked service.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * LinkedService specific properties.
     */
    public val properties: Output<LinkedServicePropsResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                linkedServicePropsResponseToKotlin(args0)
            })
        })

    /**
     * Resource type of linked service.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LinkedServiceMapper : ResourceMapper<LinkedService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.LinkedService::class == javaResource::class

    override fun map(javaResource: Resource): LinkedService = LinkedService(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.LinkedService,
    )
}

/**
 * @see [LinkedService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LinkedService].
 */
public suspend fun linkedService(
    name: String,
    block: suspend LinkedServiceResourceBuilder.() -> Unit,
): LinkedService {
    val builder = LinkedServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LinkedService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun linkedService(name: String): LinkedService {
    val builder = LinkedServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
