@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.MachineLearningDatasetArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.DatasetType
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestParametersArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestParametersArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestRegistrationArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestRegistrationArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestTimeSeriesArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestTimeSeriesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Machine Learning dataset object wrapped into ARM resource envelope.
 * Azure REST API version: 2020-05-01-preview. Prior API version in Azure Native 1.x: 2020-05-01-preview.
 * ## Example Usage
 * ### Create Dataset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDataset = new AzureNative.MachineLearningServices.MachineLearningDataset("machineLearningDataset", new()
 *     {
 *         DatasetName = "datasetName123",
 *         DatasetType = AzureNative.MachineLearningServices.DatasetType.File,
 *         Parameters = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestParametersArgs
 *         {
 *             Path = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestPathArgs
 *             {
 *                 DataPath = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestDataPathArgs
 *                 {
 *                     DatastoreName = "testblobfromarm",
 *                     RelativePath = "UI/03-26-2020_083359_UTC/latin1encoding.csv",
 *                 },
 *             },
 *         },
 *         Registration = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestRegistrationArgs
 *         {
 *             Description = "test description",
 *             Name = "datasetName123",
 *         },
 *         ResourceGroupName = "acjain-mleastUS2",
 *         SkipValidation = false,
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDataset(ctx, "machineLearningDataset", &machinelearningservices.MachineLearningDatasetArgs{
 * 			DatasetName: pulumi.String("datasetName123"),
 * 			DatasetType: pulumi.String(machinelearningservices.DatasetTypeFile),
 * 			Parameters: &machinelearningservices.DatasetCreateRequestParametersArgs{
 * 				Path: &machinelearningservices.DatasetCreateRequestPathArgs{
 * 					DataPath: &machinelearningservices.DatasetCreateRequestDataPathArgs{
 * 						DatastoreName: pulumi.String("testblobfromarm"),
 * 						RelativePath:  pulumi.String("UI/03-26-2020_083359_UTC/latin1encoding.csv"),
 * 					},
 * 				},
 * 			},
 * 			Registration: &machinelearningservices.DatasetCreateRequestRegistrationArgs{
 * 				Description: pulumi.String("test description"),
 * 				Name:        pulumi.String("datasetName123"),
 * 			},
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			SkipValidation:    pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDataset;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatasetArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestParametersArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestPathArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestDataPathArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDataset = new MachineLearningDataset("machineLearningDataset", MachineLearningDatasetArgs.builder()
 *             .datasetName("datasetName123")
 *             .datasetType("file")
 *             .parameters(DatasetCreateRequestParametersArgs.builder()
 *                 .path(DatasetCreateRequestPathArgs.builder()
 *                     .dataPath(DatasetCreateRequestDataPathArgs.builder()
 *                         .datastoreName("testblobfromarm")
 *                         .relativePath("UI/03-26-2020_083359_UTC/latin1encoding.csv")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .registration(DatasetCreateRequestRegistrationArgs.builder()
 *                 .description("test description")
 *                 .name("datasetName123")
 *                 .build())
 *             .resourceGroupName("acjain-mleastUS2")
 *             .skipValidation(false)
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:MachineLearningDataset datasetName123 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/datasets/{datasetName}
 * ```
 * @property datasetName The Dataset name.
 * @property datasetType Specifies dataset type.
 * @property parameters
 * @property registration
 * @property resourceGroupName Name of the resource group in which workspace is located.
 * @property skipValidation Skip validation that ensures data can be loaded from the dataset before registration.
 * @property timeSeries
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class MachineLearningDatasetArgs(
    public val datasetName: Output<String>? = null,
    public val datasetType: Output<Either<String, DatasetType>>? = null,
    public val parameters: Output<DatasetCreateRequestParametersArgs>? = null,
    public val registration: Output<DatasetCreateRequestRegistrationArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val skipValidation: Output<Boolean>? = null,
    public val timeSeries: Output<DatasetCreateRequestTimeSeriesArgs>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.MachineLearningDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.MachineLearningDatasetArgs =
        com.pulumi.azurenative.machinelearningservices.MachineLearningDatasetArgs.builder()
            .datasetName(datasetName?.applyValue({ args0 -> args0 }))
            .datasetType(
                datasetType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registration(registration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .skipValidation(skipValidation?.applyValue({ args0 -> args0 }))
            .timeSeries(timeSeries?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MachineLearningDatasetArgs].
 */
@PulumiTagMarker
public class MachineLearningDatasetArgsBuilder internal constructor() {
    private var datasetName: Output<String>? = null

    private var datasetType: Output<Either<String, DatasetType>>? = null

    private var parameters: Output<DatasetCreateRequestParametersArgs>? = null

    private var registration: Output<DatasetCreateRequestRegistrationArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var skipValidation: Output<Boolean>? = null

    private var timeSeries: Output<DatasetCreateRequestTimeSeriesArgs>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The Dataset name.
     */
    @JvmName("nbfjrkyirdvtqdbx")
    public suspend fun datasetName(`value`: Output<String>) {
        this.datasetName = value
    }

    /**
     * @param value Specifies dataset type.
     */
    @JvmName("ielaxsbgjrnhsrvp")
    public suspend fun datasetType(`value`: Output<Either<String, DatasetType>>) {
        this.datasetType = value
    }

    /**
     * @param value
     */
    @JvmName("aarhxqusniiftcdx")
    public suspend fun parameters(`value`: Output<DatasetCreateRequestParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value
     */
    @JvmName("oookixqpeyamevfu")
    public suspend fun registration(`value`: Output<DatasetCreateRequestRegistrationArgs>) {
        this.registration = value
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("bewtirqnbjedyxrl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Skip validation that ensures data can be loaded from the dataset before registration.
     */
    @JvmName("ebygqiocwrpbvvmu")
    public suspend fun skipValidation(`value`: Output<Boolean>) {
        this.skipValidation = value
    }

    /**
     * @param value
     */
    @JvmName("ejwhblbcaamkhntm")
    public suspend fun timeSeries(`value`: Output<DatasetCreateRequestTimeSeriesArgs>) {
        this.timeSeries = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("ggsyeppmoqmsrebe")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The Dataset name.
     */
    @JvmName("nexchvfemotecsvv")
    public suspend fun datasetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasetName = mapped
    }

    /**
     * @param value Specifies dataset type.
     */
    @JvmName("cihavtropgdcoxqg")
    public suspend fun datasetType(`value`: Either<String, DatasetType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasetType = mapped
    }

    /**
     * @param value Specifies dataset type.
     */
    @JvmName("tcifrxdvabakajok")
    public fun datasetType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatasetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datasetType = mapped
    }

    /**
     * @param value Specifies dataset type.
     */
    @JvmName("ysriafyytmpwixfk")
    public fun datasetType(`value`: DatasetType) {
        val toBeMapped = Either.ofRight<String, DatasetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datasetType = mapped
    }

    /**
     * @param value
     */
    @JvmName("mrpoeeowyabqurwf")
    public suspend fun parameters(`value`: DatasetCreateRequestParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tkcoaikxnrotfygg")
    public suspend fun parameters(argument: suspend DatasetCreateRequestParametersArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCreateRequestParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value
     */
    @JvmName("pxcqvihxfbjacdnx")
    public suspend fun registration(`value`: DatasetCreateRequestRegistrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lbrgrettelrwyplb")
    public suspend fun registration(argument: suspend DatasetCreateRequestRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCreateRequestRegistrationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.registration = mapped
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("ombqphscgvmitkaj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Skip validation that ensures data can be loaded from the dataset before registration.
     */
    @JvmName("ievnelpxqbqmvboy")
    public suspend fun skipValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipValidation = mapped
    }

    /**
     * @param value
     */
    @JvmName("kbrscumtrggvnkod")
    public suspend fun timeSeries(`value`: DatasetCreateRequestTimeSeriesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSeries = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jpdveijsysvxqmhe")
    public suspend fun timeSeries(argument: suspend DatasetCreateRequestTimeSeriesArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCreateRequestTimeSeriesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeSeries = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("ujygnrgpbadxociw")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): MachineLearningDatasetArgs = MachineLearningDatasetArgs(
        datasetName = datasetName,
        datasetType = datasetType,
        parameters = parameters,
        registration = registration,
        resourceGroupName = resourceGroupName,
        skipValidation = skipValidation,
        timeSeries = timeSeries,
        workspaceName = workspaceName,
    )
}
