@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DatastoreResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DatastoreResponse.Companion.toKotlin as datastoreResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [MachineLearningDatastore].
 */
@PulumiTagMarker
public class MachineLearningDatastoreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MachineLearningDatastoreArgs = MachineLearningDatastoreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MachineLearningDatastoreArgsBuilder.() -> Unit) {
        val builder = MachineLearningDatastoreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MachineLearningDatastore {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MachineLearningDatastore(builtJavaResource)
    }
}

/**
 * Machine Learning datastore object wrapped into ARM resource envelope.
 * Azure REST API version: 2020-05-01-preview. Prior API version in Azure Native 1.x: 2020-05-01-preview.
 * ## Example Usage
 * ### Create ADLS  Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         ClientId = "233d7008-b157-4354-88d1-ba191f06a900",
 *         ClientSecret = "vdvgdvdvdv",
 *         DataStoreType = AzureNative.MachineLearningServices.DatastoreTypeArm.Adls,
 *         DatastoreName = "adlsDatastore",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         StoreName = "stanley",
 *         TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			ClientId:          pulumi.String("233d7008-b157-4354-88d1-ba191f06a900"),
 * 			ClientSecret:      pulumi.String("vdvgdvdvdv"),
 * 			DataStoreType:     pulumi.String(machinelearningservices.DatastoreTypeArmAdls),
 * 			DatastoreName:     pulumi.String("adlsDatastore"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			StoreName:         pulumi.String("stanley"),
 * 			TenantId:          pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .clientId("233d7008-b157-4354-88d1-ba191f06a900")
 *             .clientSecret("vdvgdvdvdv")
 *             .dataStoreType("adls")
 *             .datastoreName("adlsDatastore")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .storeName("stanley")
 *             .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create ADLS Gen2 Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         AccountName = "nicksadlsgen2storage",
 *         ClientId = "233d7008-b157-4354-88d1-ba191f06a900",
 *         ClientSecret = "vdegbvedgeg",
 *         DataStoreType = AzureNative.MachineLearningServices.DatastoreTypeArm.Adls_gen2,
 *         DatastoreName = "adlsgen2Datastore",
 *         FileSystem = "testfs1",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			AccountName:       pulumi.String("nicksadlsgen2storage"),
 * 			ClientId:          pulumi.String("233d7008-b157-4354-88d1-ba191f06a900"),
 * 			ClientSecret:      pulumi.String("vdegbvedgeg"),
 * 			DataStoreType:     pulumi.String(machinelearningservices.DatastoreTypeArm_Adls_Gen2),
 * 			DatastoreName:     pulumi.String("adlsgen2Datastore"),
 * 			FileSystem:        pulumi.String("testfs1"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			TenantId:          pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .accountName("nicksadlsgen2storage")
 *             .clientId("233d7008-b157-4354-88d1-ba191f06a900")
 *             .clientSecret("vdegbvedgeg")
 *             .dataStoreType("adls-gen2")
 *             .datastoreName("adlsgen2Datastore")
 *             .fileSystem("testfs1")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Blob Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         AccountKey = "wddrfewfewsgewgrrwegwreg",
 *         AccountName = "acjainmleastus9484093746",
 *         ContainerName = "azureml-blobstore-5da947c5-53aa-41a5-bb2b-074074e73b7",
 *         DataStoreType = AzureNative.MachineLearningServices.DatastoreTypeArm.Blob,
 *         DatastoreName = "blobDatastore",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			AccountKey:        pulumi.String("wddrfewfewsgewgrrwegwreg"),
 * 			AccountName:       pulumi.String("acjainmleastus9484093746"),
 * 			ContainerName:     pulumi.String("azureml-blobstore-5da947c5-53aa-41a5-bb2b-074074e73b7"),
 * 			DataStoreType:     pulumi.String(machinelearningservices.DatastoreTypeArmBlob),
 * 			DatastoreName:     pulumi.String("blobDatastore"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .accountKey("wddrfewfewsgewgrrwegwreg")
 *             .accountName("acjainmleastus9484093746")
 *             .containerName("azureml-blobstore-5da947c5-53aa-41a5-bb2b-074074e73b7")
 *             .dataStoreType("blob")
 *             .datastoreName("blobDatastore")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Databricks File System Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         DataStoreType = AzureNative.MachineLearningServices.DatastoreTypeArm.Dbfs,
 *         DatastoreName = "blobDatastore",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			DataStoreType:     pulumi.String(machinelearningservices.DatastoreTypeArmDbfs),
 * 			DatastoreName:     pulumi.String("blobDatastore"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .dataStoreType("dbfs")
 *             .datastoreName("blobDatastore")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create File Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         AccountKey = "wddrfewfewsgewgrrwegwreg",
 *         AccountName = "acjainmleastus9484093746",
 *         DataStoreType = AzureNative.MachineLearningServices.DatastoreTypeArm.File,
 *         DatastoreName = "fileDatastore",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         ShareName = "azureml-filestore-5da947c5-53aa-41a5-bb2b-074074e73b76",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			AccountKey:        pulumi.String("wddrfewfewsgewgrrwegwreg"),
 * 			AccountName:       pulumi.String("acjainmleastus9484093746"),
 * 			DataStoreType:     pulumi.String(machinelearningservices.DatastoreTypeArmFile),
 * 			DatastoreName:     pulumi.String("fileDatastore"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			ShareName:         pulumi.String("azureml-filestore-5da947c5-53aa-41a5-bb2b-074074e73b76"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .accountKey("wddrfewfewsgewgrrwegwreg")
 *             .accountName("acjainmleastus9484093746")
 *             .dataStoreType("file")
 *             .datastoreName("fileDatastore")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .shareName("azureml-filestore-5da947c5-53aa-41a5-bb2b-074074e73b76")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create MySQL Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         DataStoreType = AzureNative.MachineLearningServices.DatastoreTypeArm.Mysqldb,
 *         DatabaseName = "dataset",
 *         DatastoreName = "mySqlDatastore",
 *         Password = "<password>",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         ServerName = "dataset-mysql-srv",
 *         UserId = "demo_user@dataset-mysql-srv",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			DataStoreType:     pulumi.String(machinelearningservices.DatastoreTypeArmMysqldb),
 * 			DatabaseName:      pulumi.String("dataset"),
 * 			DatastoreName:     pulumi.String("mySqlDatastore"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			ServerName:        pulumi.String("dataset-mysql-srv"),
 * 			UserId:            pulumi.String("demo_user@dataset-mysql-srv"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .dataStoreType("mysqldb")
 *             .databaseName("dataset")
 *             .datastoreName("mySqlDatastore")
 *             .password("<password>")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .serverName("dataset-mysql-srv")
 *             .userId("demo_user@dataset-mysql-srv")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create PostgreSQL Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         DataStoreType = AzureNative.MachineLearningServices.DatastoreTypeArm.Psqldb,
 *         DatabaseName = "dataset",
 *         DatastoreName = "postgreSqlDatastore",
 *         Password = "<password>",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         ServerName = "dataset-pgsql-srv",
 *         UserId = "demo_user@dataset-pgsql-srv",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			DataStoreType:     pulumi.String(machinelearningservices.DatastoreTypeArmPsqldb),
 * 			DatabaseName:      pulumi.String("dataset"),
 * 			DatastoreName:     pulumi.String("postgreSqlDatastore"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			ServerName:        pulumi.String("dataset-pgsql-srv"),
 * 			UserId:            pulumi.String("demo_user@dataset-pgsql-srv"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .dataStoreType("psqldb")
 *             .databaseName("dataset")
 *             .datastoreName("postgreSqlDatastore")
 *             .password("<password>")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .serverName("dataset-pgsql-srv")
 *             .userId("demo_user@dataset-pgsql-srv")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create SQL Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         DataStoreType = AzureNative.MachineLearningServices.DatastoreTypeArm.Sqldb,
 *         DatabaseName = "dataset",
 *         DatastoreName = "sqlDatastore",
 *         Password = "<password>",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         ServerName = "dataset-azsql-srv",
 *         UserName = "demo_user",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			DataStoreType:     pulumi.String(machinelearningservices.DatastoreTypeArmSqldb),
 * 			DatabaseName:      pulumi.String("dataset"),
 * 			DatastoreName:     pulumi.String("sqlDatastore"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			ServerName:        pulumi.String("dataset-azsql-srv"),
 * 			UserName:          pulumi.String("demo_user"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .dataStoreType("sqldb")
 *             .databaseName("dataset")
 *             .datastoreName("sqlDatastore")
 *             .password("<password>")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .serverName("dataset-azsql-srv")
 *             .userName("demo_user")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:MachineLearningDatastore sqlDatastore /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/datastores/{datastoreName}
 * ```
 */
public class MachineLearningDatastore internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore,
) : KotlinCustomResource(javaResource, MachineLearningDatastoreMapper) {
    /**
     * The identity of the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Datastore properties
     */
    public val properties: Output<DatastoreResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                datastoreResponseToKotlin(args0)
            })
        })

    /**
     * The sku of the workspace.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Contains resource tags defined as key/value pairs.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MachineLearningDatastoreMapper : ResourceMapper<MachineLearningDatastore> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore::class == javaResource::class

    override fun map(javaResource: Resource): MachineLearningDatastore =
        MachineLearningDatastore(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore,
        )
}

/**
 * @see [MachineLearningDatastore].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MachineLearningDatastore].
 */
public suspend fun machineLearningDatastore(
    name: String,
    block: suspend MachineLearningDatastoreResourceBuilder.() -> Unit,
): MachineLearningDatastore {
    val builder = MachineLearningDatastoreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MachineLearningDatastore].
 * @param name The _unique_ name of the resulting resource.
 */
public fun machineLearningDatastore(name: String): MachineLearningDatastore {
    val builder = MachineLearningDatastoreResourceBuilder()
    builder.name(name)
    return builder.build()
}
