@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.KubernetesOnlineDeploymentResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedOnlineDeploymentResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [OnlineDeployment].
 */
@PulumiTagMarker
public class OnlineDeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OnlineDeploymentArgs = OnlineDeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OnlineDeploymentArgsBuilder.() -> Unit) {
        val builder = OnlineDeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OnlineDeployment {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.OnlineDeployment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OnlineDeployment(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:OnlineDeployment string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/onlineEndpoints/{endpointName}/deployments/{deploymentName}
 * ```
 */
public class OnlineDeployment internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.OnlineDeployment,
) : KotlinCustomResource(javaResource, OnlineDeploymentMapper) {
    /**
     * Managed service identity (system assigned and/or user assigned identities)
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * [Required] Additional attributes of the entity.
     */
    public val onlineDeploymentProperties:
        Output<Either<KubernetesOnlineDeploymentResponse, ManagedOnlineDeploymentResponse>>
        get() = javaResource.onlineDeploymentProperties().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.KubernetesOnlineDeploymentResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedOnlineDeploymentResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * Sku details required for ARM contract for Autoscaling.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OnlineDeploymentMapper : ResourceMapper<OnlineDeployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.OnlineDeployment::class == javaResource::class

    override fun map(javaResource: Resource): OnlineDeployment = OnlineDeployment(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.OnlineDeployment,
    )
}

/**
 * @see [OnlineDeployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OnlineDeployment].
 */
public suspend fun onlineDeployment(
    name: String,
    block: suspend OnlineDeploymentResourceBuilder.() -> Unit,
): OnlineDeployment {
    val builder = OnlineDeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OnlineDeployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun onlineDeployment(name: String): OnlineDeployment {
    val builder = OnlineDeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
