@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RaiPolicyArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RaiPolicyPropertiesArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RaiPolicyPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure OpenAI Content Filters resource.
 * Azure REST API version: 2024-04-01-preview.
 * ## Example Usage
 * ### Create Rai policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var raiPolicy = new AzureNative.MachineLearningServices.RaiPolicy("raiPolicy", new()
 *     {
 *         EndpointName = "Azure.OpenAI",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.RaiPolicyPropertiesArgs
 *         {
 *             BasePolicyName = "112",
 *             CompletionBlocklists = new[]
 *             {
 *                 new AzureNative.MachineLearningServices.Inputs.RaiBlocklistConfigArgs
 *                 {
 *                     Blocking = false,
 *                     BlocklistName = "blocklistName",
 *                 },
 *             },
 *             ContentFilters = new[]
 *             {
 *                 new AzureNative.MachineLearningServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.MachineLearningServices.AllowedContentLevel.Low,
 *                     Blocking = false,
 *                     Enabled = false,
 *                     Name = "policyName",
 *                     Source = AzureNative.MachineLearningServices.RaiPolicyContentSource.Prompt,
 *                 },
 *             },
 *             Mode = AzureNative.MachineLearningServices.RaiPolicyMode.Blocking,
 *             PromptBlocklists = new[]
 *             {
 *                 new AzureNative.MachineLearningServices.Inputs.RaiBlocklistConfigArgs
 *                 {
 *                     Blocking = false,
 *                     BlocklistName = "blocklistName",
 *                 },
 *             },
 *             Type = AzureNative.MachineLearningServices.RaiPolicyType.SystemManaged,
 *         },
 *         RaiPolicyName = "raiPolicyName",
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "aml-workspace-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRaiPolicy(ctx, "raiPolicy", &machinelearningservices.RaiPolicyArgs{
 * 			EndpointName: pulumi.String("Azure.OpenAI"),
 * 			Properties: &machinelearningservices.RaiPolicyPropertiesArgs{
 * 				BasePolicyName: pulumi.String("112"),
 * 				CompletionBlocklists: machinelearningservices.RaiBlocklistConfigArray{
 * 					&machinelearningservices.RaiBlocklistConfigArgs{
 * 						Blocking:      pulumi.Bool(false),
 * 						BlocklistName: pulumi.String("blocklistName"),
 * 					},
 * 				},
 * 				ContentFilters: machinelearningservices.RaiPolicyContentFilterArray{
 * 					&machinelearningservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(machinelearningservices.AllowedContentLevelLow),
 * 						Blocking:            pulumi.Bool(false),
 * 						Enabled:             pulumi.Bool(false),
 * 						Name:                pulumi.String("policyName"),
 * 						Source:              pulumi.String(machinelearningservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 				},
 * 				Mode: pulumi.String(machinelearningservices.RaiPolicyModeBlocking),
 * 				PromptBlocklists: machinelearningservices.RaiBlocklistConfigArray{
 * 					&machinelearningservices.RaiBlocklistConfigArgs{
 * 						Blocking:      pulumi.Bool(false),
 * 						BlocklistName: pulumi.String("blocklistName"),
 * 					},
 * 				},
 * 				Type: pulumi.String(machinelearningservices.RaiPolicyTypeSystemManaged),
 * 			},
 * 			RaiPolicyName:     pulumi.String("raiPolicyName"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			WorkspaceName:     pulumi.String("aml-workspace-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RaiPolicy;
 * import com.pulumi.azurenative.machinelearningservices.RaiPolicyArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.RaiPolicyPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var raiPolicy = new RaiPolicy("raiPolicy", RaiPolicyArgs.builder()
 *             .endpointName("Azure.OpenAI")
 *             .properties(RaiPolicyPropertiesArgs.builder()
 *                 .basePolicyName("112")
 *                 .completionBlocklists(RaiBlocklistConfigArgs.builder()
 *                     .blocking(false)
 *                     .blocklistName("blocklistName")
 *                     .build())
 *                 .contentFilters(RaiPolicyContentFilterArgs.builder()
 *                     .allowedContentLevel("Low")
 *                     .blocking(false)
 *                     .enabled(false)
 *                     .name("policyName")
 *                     .source("Prompt")
 *                     .build())
 *                 .mode("Blocking")
 *                 .promptBlocklists(RaiBlocklistConfigArgs.builder()
 *                     .blocking(false)
 *                     .blocklistName("blocklistName")
 *                     .build())
 *                 .type("SystemManaged")
 *                 .build())
 *             .raiPolicyName("raiPolicyName")
 *             .resourceGroupName("test-rg")
 *             .workspaceName("aml-workspace-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RaiPolicy raiPolicyName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/endpoints/{endpointName}/raiPolicies/{raiPolicyName}
 * ```
 * @property endpointName Name of the endpoint resource.
 * @property properties Azure OpenAI Content Filters properties.
 * @property raiPolicyName Name of the Rai Policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Azure Machine Learning Workspace Name
 */
public data class RaiPolicyArgs(
    public val endpointName: Output<String>? = null,
    public val properties: Output<RaiPolicyPropertiesArgs>? = null,
    public val raiPolicyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RaiPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.RaiPolicyArgs =
        com.pulumi.azurenative.machinelearningservices.RaiPolicyArgs.builder()
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .raiPolicyName(raiPolicyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RaiPolicyArgs].
 */
@PulumiTagMarker
public class RaiPolicyArgsBuilder internal constructor() {
    private var endpointName: Output<String>? = null

    private var properties: Output<RaiPolicyPropertiesArgs>? = null

    private var raiPolicyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Name of the endpoint resource.
     */
    @JvmName("jaeytetkqwlelyjv")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value Azure OpenAI Content Filters properties.
     */
    @JvmName("pqmwigskmirwfwvq")
    public suspend fun properties(`value`: Output<RaiPolicyPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Rai Policy.
     */
    @JvmName("srcpwcdlpovgugvt")
    public suspend fun raiPolicyName(`value`: Output<String>) {
        this.raiPolicyName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iuceagmjqyhjtlfc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("xgagwkittdqynqdv")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Name of the endpoint resource.
     */
    @JvmName("fbrwncigrfvmdhwe")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value Azure OpenAI Content Filters properties.
     */
    @JvmName("toocnwxksgoyyfmd")
    public suspend fun properties(`value`: RaiPolicyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Azure OpenAI Content Filters properties.
     */
    @JvmName("dewgiiwfojspvojh")
    public suspend fun properties(argument: suspend RaiPolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RaiPolicyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Rai Policy.
     */
    @JvmName("abfdlcignnqswtmu")
    public suspend fun raiPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raiPolicyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nevkborodmouatll")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("nfaswgintyfbbppe")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): RaiPolicyArgs = RaiPolicyArgs(
        endpointName = endpointName,
        properties = properties,
        raiPolicyName = raiPolicyName,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
